/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.jigsaw.admin;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;
import org.w3c.jigsaw.admin.AdminContext;
import org.w3c.jigsaw.admin.RemoteAccessException;
import org.w3c.jigsaw.admin.RemoteResource;
import org.w3c.tools.codec.Base64Encoder;
import org.w3c.www.http.HttpCredential;
import org.w3c.www.http.HttpFactory;

public class JigKill {
    protected static final int EXIT_SUCCESS = 0;
    protected static final int EXIT_FAILURE = 1;
    protected RemoteResource adminServer = null;
    protected RemoteResource[] ctrls = null;

    protected static void usage() {
        System.err.println("Usage:\n\tjava org.w3c.jigsaw.admin.JigKill -u <username> -p <password> [--save] [--stop] [--ping] <admin server url>\n");
        System.exit(1);
    }

    protected RemoteResource[] getControls(RemoteResource remoteResource) throws RemoteAccessException {
        String[] stringArray = remoteResource.enumerateResourceIdentifiers();
        Vector<RemoteResource> vector = new Vector<RemoteResource>(2);
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("control") || stringArray[i].equals("realms")) continue;
            RemoteResource remoteResource2 = remoteResource.loadResource(stringArray[i]);
            RemoteResource remoteResource3 = remoteResource2.loadResource("control");
            vector.addElement(remoteResource3);
        }
        Object[] objectArray = new RemoteResource[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public void kill() throws RemoteAccessException {
        this.save();
        this.stop();
    }

    public void stop() throws RemoteAccessException {
        this.doLoadResource("stop");
    }

    public void save() throws RemoteAccessException {
        this.doLoadResource("save");
    }

    protected void doLoadResource(String string) throws RemoteAccessException {
        for (int i = 0; i < this.ctrls.length; ++i) {
            this.ctrls[i].loadResource(string);
        }
        RemoteResource remoteResource = this.adminServer.loadResource("control");
        remoteResource.loadResource(string);
    }

    public JigKill(URL uRL, String string, String string2) throws RemoteAccessException {
        AdminContext adminContext = new AdminContext(uRL);
        HttpCredential httpCredential = HttpFactory.makeCredential("Basic");
        Base64Encoder base64Encoder = new Base64Encoder(string + ":" + string2);
        httpCredential.setAuthParameter("cookie", base64Encoder.processString());
        adminContext.setCredential(httpCredential);
        adminContext.initialize();
        this.adminServer = adminContext.getAdminResource();
        this.ctrls = this.getControls(this.adminServer);
    }

    public static void main(String[] stringArray) {
        String string = "admin";
        String string2 = null;
        String string3 = null;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = true;
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].equals("-u") || stringArray[i].equals("--username")) {
                    string = stringArray[++i];
                    continue;
                }
                if (stringArray[i].equals("-p") || stringArray[i].equals("--password")) {
                    string2 = stringArray[++i];
                    continue;
                }
                if (stringArray[i].equals("--save")) {
                    bl = true;
                    bl4 = false;
                    continue;
                }
                if (stringArray[i].equals("--stop")) {
                    bl2 = true;
                    bl4 = false;
                    continue;
                }
                if (stringArray[i].equals("--ping")) {
                    bl3 = true;
                    bl4 = false;
                    continue;
                }
                string3 = stringArray[i];
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        if (string == null || string2 == null || string3 == null) {
            JigKill.usage();
        }
        if (bl4) {
            bl2 = true;
            bl = true;
        }
        URL uRL = null;
        try {
            uRL = new URL(string3);
        }
        catch (MalformedURLException malformedURLException) {
            System.err.println("Invalid URL : " + string3);
            System.exit(1);
        }
        try {
            JigKill jigKill = new JigKill(uRL, string, string2);
            if (bl3) {
                System.out.println("Servers are alive.");
            }
            if (bl) {
                jigKill.save();
                System.out.println("Servers saved.");
            }
            if (bl2) {
                jigKill.stop();
                System.out.println("Servers killed.");
            }
            System.exit(0);
        }
        catch (RemoteAccessException remoteAccessException) {
            String string4 = remoteAccessException.getMessage();
            if (string4.equals("Unauthorized")) {
                System.err.println("Invalid username/password.");
            } else {
                System.err.println("Error : " + string4);
            }
            System.exit(1);
        }
        catch (Exception exception) {
            System.err.println("Unexcepted fatal error:");
            exception.printStackTrace();
        }
        System.exit(1);
    }
}

