/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.jigadm.editors;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Label;
import java.awt.List;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Properties;
import org.w3c.jigadm.PropertyManager;
import org.w3c.jigadm.RemoteResourceWrapper;
import org.w3c.jigadm.editors.AttributeEditor;
import org.w3c.jigadm.editors.EditorFeeder;
import org.w3c.jigsaw.admin.RemoteAccessException;
import org.w3c.tools.resources.Attribute;
import org.w3c.tools.widgets.BorderPanel;
import org.w3c.tools.widgets.ClosableFrame;
import org.w3c.tools.widgets.ImageButton;
import org.w3c.tools.widgets.ListEditor;
import org.w3c.tools.widgets.TextEditable;

public class StringArrayEditor
extends AttributeEditor {
    public static final String FEEDER_CLASS_P = "feeder.class";
    protected boolean hasChanged = false;
    protected String[] oldvalue = null;
    protected StringArrayComponent comp = null;

    protected TextEditable getTextEditor() {
        return new TextEditor(15);
    }

    protected Dimension getPopupSize() {
        return new Dimension(350, 250);
    }

    protected void createComponent(EditorFeeder editorFeeder, String[] stringArray) {
        if (this.comp == null) {
            this.comp = new StringArrayComponent(this, stringArray, editorFeeder);
        }
    }

    protected void setModified() {
        this.hasChanged = true;
    }

    public boolean hasChanged() {
        return this.hasChanged;
    }

    public void clearChanged() {
        this.hasChanged = false;
    }

    public void resetChanges() {
        this.hasChanged = false;
        this.comp.setSelectedItems(this.oldvalue);
    }

    public Object getValue() {
        return this.comp.getSelectedItems();
    }

    public void setValue(Object object) {
        this.oldvalue = (String[])object;
        this.comp.setSelectedItems(this.oldvalue);
    }

    public Component getComponent() {
        return this.comp;
    }

    public void initialize(RemoteResourceWrapper remoteResourceWrapper, Attribute attribute, Object object, Properties properties) throws RemoteAccessException {
        EditorFeeder editorFeeder = null;
        String string = null;
        string = (String)properties.get(FEEDER_CLASS_P);
        if (string == null) {
            throw new RuntimeException("StringArrayEditor mis-configuration: feeder.class property undefined.");
        }
        try {
            Class<?> clazz = Class.forName(string);
            editorFeeder = (EditorFeeder)clazz.newInstance();
            editorFeeder.initialize(remoteResourceWrapper, properties);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new RuntimeException("StringArrayEditor mis-configured:  unable to instantiate " + string + ".");
        }
        this.createComponent(editorFeeder, (String[])object);
        this.oldvalue = (String[])object;
    }

    class TextEditor
    extends TextField
    implements TextEditable {
        public boolean updated() {
            return this.getText().length() > 0 && !this.getText().equals("");
        }

        public void setDefault() {
            this.setText("");
        }

        TextEditor(int n) {
            super(n);
        }
    }

    class StringArrayComponent
    extends ListEditor {
        protected StringArrayEditor editor = null;
        protected EditStringArrayPopup popup = null;
        protected String[] selected = null;
        protected EditorFeeder feeder = null;

        protected void edit() {
            if (this.popup == null) {
                this.popup = new EditStringArrayPopup(this, this.feeder, this.getSelectedItems(), "Edit");
            } else {
                this.popup.start(this.getSelectedItems());
            }
            this.popup.show();
            this.popup.toFront();
        }

        public void setModified() {
            this.editor.setModified();
        }

        protected void setSelectedItems(String[] stringArray) {
            this.list.removeAll();
            if (stringArray != null) {
                for (int i = 0; i < stringArray.length; ++i) {
                    if (stringArray[i] == null) continue;
                    this.list.addItem(stringArray[i]);
                }
            }
        }

        protected String[] getSelectedItems() {
            return this.list.getItems();
        }

        StringArrayComponent(StringArrayEditor stringArrayEditor2, String[] stringArray, EditorFeeder editorFeeder) {
            super(5, true);
            this.editor = stringArrayEditor2;
            this.selected = stringArray;
            this.feeder = editorFeeder;
            this.setSelectedItems(stringArray);
        }
    }

    class EditStringArrayPopup
    extends ClosableFrame
    implements ActionListener {
        protected StringArrayComponent parent = null;
        protected EditorFeeder feeder = null;
        protected String[] selected = null;
        protected List witems = null;
        protected Panel items = null;
        protected Panel pitems = null;
        protected ImageButton waddItem = null;
        protected ImageButton wdelItem = null;
        protected List wselected = null;
        protected Panel pselected = null;
        protected TextEditable newItem = null;
        protected boolean modified = false;

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals("add")) {
                if (this.newItem.updated()) {
                    this.modified = true;
                    this.wselected.addItem(this.newItem.getText());
                }
                this.newItem.setDefault();
                int[] nArray = this.witems.getSelectedIndexes();
                if (nArray != null && nArray.length > 0) {
                    int n;
                    this.modified = true;
                    for (n = 0; n < nArray.length; ++n) {
                        String string2 = this.witems.getItem(nArray[n]);
                        this.wselected.addItem(string2);
                        this.witems.deselect(nArray[n]);
                    }
                    for (n = 0; n < nArray.length; ++n) {
                        this.witems.delItem(nArray[n] - n);
                    }
                }
            } else if (string.equals("del")) {
                int[] nArray = this.wselected.getSelectedIndexes();
                if (nArray != null && nArray.length > 0) {
                    int n;
                    this.modified = true;
                    for (n = 0; n < nArray.length; ++n) {
                        String string3 = this.wselected.getItem(nArray[n]);
                        this.witems.addItem(string3);
                        this.wselected.deselect(nArray[n]);
                    }
                    for (n = 0; n < nArray.length; ++n) {
                        this.wselected.delItem(nArray[n] - n);
                    }
                }
            } else if (string.equals("update")) {
                if (this.modified) {
                    this.parent.setSelectedItems(this.wselected.getItems());
                    this.parent.setModified();
                }
                this.setVisible(false);
            } else if (string.equals("cancel")) {
                this.close();
            } else if (actionEvent.getSource().equals(this.newItem)) {
                if (this.newItem.updated()) {
                    this.modified = true;
                    this.wselected.addItem(this.newItem.getText());
                }
                this.newItem.setDefault();
                this.wselected.requestFocus();
            }
        }

        protected void close() {
            this.modified = false;
            this.setVisible(false);
        }

        protected void createDefaultItems(EditorFeeder editorFeeder) {
            this.witems = new List(4, false);
            this.witems.setBackground(Color.white);
            this.witems.setMultipleMode(true);
            String[] stringArray = editorFeeder.getDefaultItems();
            if (stringArray != null) {
                for (int i = 0; i < stringArray.length; ++i) {
                    if (stringArray[i] == null) continue;
                    this.witems.addItem(stringArray[i]);
                }
            }
        }

        protected void setDefaultItems(EditorFeeder editorFeeder) {
            this.witems.removeAll();
            String[] stringArray = editorFeeder.getDefaultItems();
            if (stringArray != null) {
                for (int i = 0; i < stringArray.length; ++i) {
                    if (stringArray[i] == null) continue;
                    this.witems.addItem(stringArray[i]);
                }
            }
        }

        protected void createSelectedItems() {
            this.wselected = new List(7, false);
            this.wselected.setMultipleMode(true);
            this.wselected.setBackground(Color.white);
        }

        protected void setSelectedItems(String[] stringArray) {
            this.wselected.removeAll();
            if (stringArray != null) {
                for (int i = 0; i < stringArray.length; ++i) {
                    if (stringArray[i] == null) continue;
                    this.wselected.addItem(stringArray[i]);
                }
            }
        }

        protected String[] getSelectedItems() {
            return this.wselected.getItems();
        }

        protected void updateSize() {
            this.setSize(this.parent.editor.getPopupSize());
        }

        public void start(String[] stringArray) {
            this.modified = false;
            this.setSelectedItems(stringArray);
            this.setDefaultItems(this.feeder);
        }

        public EditStringArrayPopup(StringArrayComponent stringArrayComponent, EditorFeeder editorFeeder, String[] stringArray, String string) {
            super(string);
            PropertyManager propertyManager = PropertyManager.getPropertyManager();
            Image image = Toolkit.getDefaultToolkit().getImage(propertyManager.getIconLocation("shadowleft"));
            Image image2 = Toolkit.getDefaultToolkit().getImage(propertyManager.getIconLocation("shadowright"));
            this.selected = stringArray;
            this.parent = stringArrayComponent;
            this.feeder = editorFeeder;
            this.newItem = stringArrayComponent.editor.getTextEditor();
            this.createDefaultItems(editorFeeder);
            this.createSelectedItems();
            this.setSelectedItems(stringArray);
            this.waddItem = new ImageButton(image);
            this.waddItem.setActionCommand("add");
            this.waddItem.addActionListener(this);
            Panel panel = new Panel();
            panel.add(this.waddItem);
            this.wdelItem = new ImageButton(image2);
            this.wdelItem.setActionCommand("del");
            this.wdelItem.addActionListener(this);
            Panel panel2 = new Panel();
            panel2.add((Component)this.wdelItem, "Center");
            Button button = new Button("Ok");
            button.setActionCommand("update");
            button.addActionListener(this);
            Button button2 = new Button("Cancel");
            button2.setActionCommand("cancel");
            button2.addActionListener(this);
            Panel panel3 = new Panel(new BorderLayout(3, 3));
            Panel panel4 = new Panel();
            panel4.add(new Label("Selection"));
            panel3.add((Component)panel4, "North");
            panel3.add((Component)this.wselected, "Center");
            Panel panel5 = new Panel(new BorderLayout(3, 3));
            this.newItem.addActionListener(this);
            panel5.add((Component)((Object)this.newItem), "North");
            panel5.add((Component)this.witems, "Center");
            BorderPanel borderPanel = new BorderPanel(3);
            borderPanel.add(panel2);
            borderPanel.add(panel);
            BorderPanel borderPanel2 = new BorderPanel(3);
            borderPanel2.setLayout(new GridLayout(1, 2, 20, 5));
            borderPanel2.add(panel3);
            borderPanel2.add(panel5);
            Panel panel6 = new Panel(new GridLayout(1, 2, 5, 5));
            panel6.add(button);
            panel6.add(button2);
            BorderPanel borderPanel3 = new BorderPanel(3);
            borderPanel3.add(panel6);
            BorderPanel borderPanel4 = new BorderPanel(4, 5);
            borderPanel4.setLayout(new BorderLayout());
            borderPanel4.setInsets(new Insets(10, 10, 10, 10));
            borderPanel4.add((Component)borderPanel, "North");
            borderPanel4.add((Component)borderPanel2, "Center");
            borderPanel4.add((Component)borderPanel3, "South");
            this.setLayout(new BorderLayout());
            this.add(borderPanel4);
            this.updateSize();
        }
    }
}

