/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.css.property;

import com.phloc.commons.annotations.Nonempty;
import com.phloc.commons.regex.RegExHelper;
import com.phloc.commons.string.ToStringGenerator;
import com.phloc.css.property.CSSPropertyEnum;
import com.phloc.css.property.ECSSProperty;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class CSSPropertyEnums
extends CSSPropertyEnum {
    private final int m_nMinNumbers;
    private final int m_nMaxNumbers;

    public CSSPropertyEnums(@Nonnull ECSSProperty eProp, @Nonnegative int nMinNumbers, @Nonnegative int nMaxNumbers, String ... aEnumValues) {
        super(eProp, aEnumValues);
        if (nMinNumbers < 0) {
            throw new IllegalArgumentException("minNumbers: " + nMinNumbers);
        }
        if (nMaxNumbers < 0 || nMaxNumbers < nMinNumbers) {
            throw new IllegalArgumentException("maxNumbers: " + nMaxNumbers);
        }
        this.m_nMinNumbers = nMinNumbers;
        this.m_nMaxNumbers = nMaxNumbers;
    }

    public CSSPropertyEnums(@Nonnull ECSSProperty eProp, @Nonnegative int nMinNumbers, @Nonnegative int nMaxNumbers, @Nonnull @Nonempty Iterable<String> aEnumValues) {
        super(eProp, aEnumValues);
        if (nMinNumbers < 0) {
            throw new IllegalArgumentException("minNumbers: " + nMinNumbers);
        }
        if (nMaxNumbers < 0 || nMaxNumbers < nMinNumbers) {
            throw new IllegalArgumentException("maxNumbers: " + nMaxNumbers);
        }
        this.m_nMinNumbers = nMinNumbers;
        this.m_nMaxNumbers = nMaxNumbers;
    }

    @Override
    public boolean isValidValue(@Nullable String sValue) {
        if (sValue == null) {
            return false;
        }
        String[] aParts = RegExHelper.getSplitToArray((CharSequence)sValue.trim(), (String)"\\s+");
        if (aParts.length < this.m_nMinNumbers || aParts.length > this.m_nMaxNumbers) {
            return false;
        }
        for (int i = 0; i < aParts.length; ++i) {
            if (super.isValidValue(aParts[i].trim())) continue;
            return false;
        }
        return true;
    }

    @Override
    @Nonnull
    public CSSPropertyEnums getClone(@Nonnull ECSSProperty eProp) {
        return new CSSPropertyEnums(eProp, this.m_nMinNumbers, this.m_nMaxNumbers, this.m_aEnumValues);
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived((String)super.toString()).append("minNumbers", this.m_nMinNumbers).append("maxNumbers", this.m_nMaxNumbers).toString();
    }
}

