/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.xml.transform;

import com.phloc.commons.annotations.ReturnsMutableCopy;
import com.phloc.commons.error.IHasResourceErrorGroup;
import com.phloc.commons.error.IResourceError;
import com.phloc.commons.error.IResourceErrorGroup;
import com.phloc.commons.error.ResourceErrorGroup;
import com.phloc.commons.state.EChange;
import com.phloc.commons.string.ToStringGenerator;
import com.phloc.commons.xml.transform.AbstractTransformErrorListener;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import javax.xml.transform.ErrorListener;

@ThreadSafe
public class CollectingTransformErrorListener
extends AbstractTransformErrorListener
implements IHasResourceErrorGroup {
    protected final ReadWriteLock m_aRWLock = new ReentrantReadWriteLock();
    private final ResourceErrorGroup m_aErrors = new ResourceErrorGroup();

    public CollectingTransformErrorListener() {
    }

    public CollectingTransformErrorListener(@Nullable ErrorListener aWrappedErrorListener) {
        super(aWrappedErrorListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void internalLog(@Nonnull IResourceError aResError) {
        this.m_aRWLock.writeLock().lock();
        try {
            this.m_aErrors.addResourceError(aResError);
        }
        finally {
            this.m_aRWLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    @ReturnsMutableCopy
    public IResourceErrorGroup getResourceErrors() {
        this.m_aRWLock.readLock().lock();
        try {
            ResourceErrorGroup resourceErrorGroup = this.m_aErrors.getClone();
            return resourceErrorGroup;
        }
        finally {
            this.m_aRWLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public EChange clearResourceErrors() {
        this.m_aRWLock.writeLock().lock();
        try {
            EChange eChange = this.m_aErrors.clear();
            return eChange;
        }
        finally {
            this.m_aRWLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toString() {
        this.m_aRWLock.readLock().lock();
        try {
            String string = ToStringGenerator.getDerived(super.toString()).append("errors", this.m_aErrors).toString();
            return string;
        }
        finally {
            this.m_aRWLock.readLock().unlock();
        }
    }
}

