/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.xml.transform;

import com.phloc.commons.error.EErrorLevel;
import com.phloc.commons.error.IResourceError;
import com.phloc.commons.error.IResourceLocation;
import com.phloc.commons.error.ResourceError;
import com.phloc.commons.error.ResourceLocation;
import com.phloc.commons.name.IHasDisplayText;
import com.phloc.commons.string.StringHelper;
import com.phloc.commons.string.ToStringGenerator;
import com.phloc.commons.xml.transform.EXMLTransformTexts;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.SourceLocator;
import javax.xml.transform.TransformerException;

public abstract class AbstractTransformErrorListener
implements ErrorListener {
    private final ErrorListener m_aWrappedErrorListener;

    public AbstractTransformErrorListener() {
        this(null);
    }

    public AbstractTransformErrorListener(@Nullable ErrorListener aWrappedErrorListener) {
        this.m_aWrappedErrorListener = aWrappedErrorListener;
    }

    @Nullable
    public ErrorListener getWrappedErrorListener() {
        return this.m_aWrappedErrorListener;
    }

    @Nonnull
    private static IResourceError _buildError(@Nonnull TransformerException ex, @Nonnull EErrorLevel eErrorLevel, @Nonnull IHasDisplayText aErrorMsg) {
        SourceLocator aLocator = ex.getLocator();
        String sResourceID = aLocator == null ? null : StringHelper.getConcatenatedOnDemand(aLocator.getPublicId(), "/", aLocator.getSystemId());
        ResourceLocation aLocation = new ResourceLocation(sResourceID, aLocator != null ? aLocator.getLineNumber() : -1, aLocator != null ? aLocator.getColumnNumber() : -1);
        return new ResourceError((IResourceLocation)aLocation, eErrorLevel, aErrorMsg, (Throwable)ex);
    }

    protected abstract void internalLog(@Nonnull IResourceError var1);

    @Override
    public final void warning(@Nonnull TransformerException ex) throws TransformerException {
        this.internalLog(AbstractTransformErrorListener._buildError(ex, EErrorLevel.WARN, EXMLTransformTexts.TRANSFORMATION_WARNING));
        if (this.m_aWrappedErrorListener != null) {
            this.m_aWrappedErrorListener.warning(ex);
        }
    }

    @Override
    public final void error(@Nonnull TransformerException ex) throws TransformerException {
        this.internalLog(AbstractTransformErrorListener._buildError(ex, EErrorLevel.ERROR, EXMLTransformTexts.TRANSFORMATION_ERROR));
        if (this.m_aWrappedErrorListener != null) {
            this.m_aWrappedErrorListener.error(ex);
        }
    }

    @Override
    public final void fatalError(@Nonnull TransformerException ex) throws TransformerException {
        this.internalLog(AbstractTransformErrorListener._buildError(ex, EErrorLevel.FATAL_ERROR, EXMLTransformTexts.TRANSFORMATION_FATAL_ERROR));
        if (this.m_aWrappedErrorListener != null) {
            this.m_aWrappedErrorListener.fatalError(ex);
        }
    }

    public String toString() {
        return new ToStringGenerator(this).appendIfNotNull("wrappedListener", this.m_aWrappedErrorListener).toString();
    }
}

