/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.xml.schema;

import com.phloc.commons.annotations.Nonempty;
import com.phloc.commons.cache.convert.SimpleCacheWithConversion;
import com.phloc.commons.collections.ArrayHelper;
import com.phloc.commons.collections.ContainerHelper;
import com.phloc.commons.convert.IUnidirectionalConverter;
import com.phloc.commons.io.IReadableResource;
import com.phloc.commons.string.ToStringGenerator;
import com.phloc.commons.xml.sax.LoggingSAXErrorHandler;
import com.phloc.commons.xml.transform.TransformSourceFactory;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.xml.transform.Source;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.xml.sax.SAXException;

public abstract class AbstractSchemaCache
extends SimpleCacheWithConversion<String, Schema> {
    private static final String PREFIX_SYNTHETIC = "synthetic:";
    private final String m_sSchemaTypeName;

    public AbstractSchemaCache(@Nonnull String sSchemaTypeName) {
        super(AbstractSchemaCache.class.getName() + "$" + sSchemaTypeName);
        this.m_sSchemaTypeName = sSchemaTypeName;
    }

    @Nonnull
    protected abstract SchemaFactory internalGetSchemaFactory();

    @Nonnull
    private Schema _getSchema(@Nonnull String sResourceID, final @Nonnull Source[] aSources) {
        return this.getFromCache(sResourceID, new IUnidirectionalConverter<String, Schema>(){

            @Override
            @Nonnull
            public Schema convert(String sMyResourceID) {
                try {
                    Schema ret = AbstractSchemaCache.this.internalGetSchemaFactory().newSchema(aSources);
                    if (ret == null) {
                        throw new IllegalStateException("Failed to create " + AbstractSchemaCache.this.m_sSchemaTypeName + " from " + Arrays.toString(aSources));
                    }
                    return ret;
                }
                catch (SAXException ex) {
                    throw new IllegalArgumentException("Failed to parse " + AbstractSchemaCache.this.m_sSchemaTypeName + " from " + Arrays.toString(aSources), ex);
                }
            }
        });
    }

    @Nonnull
    public final Schema getSchema(@Nonnull IReadableResource aResource) {
        if (aResource == null) {
            throw new NullPointerException("resources");
        }
        return this._getSchema(aResource.getResourceID(), new Source[]{TransformSourceFactory.create(aResource)});
    }

    @Nonnull
    private Schema _getSchema(@Nonnull @Nonempty Set<IReadableResource> aRealResources) {
        if (aRealResources.size() == 1) {
            return this.getSchema(ContainerHelper.getFirstElement(aRealResources));
        }
        Source[] aSources = new Source[aRealResources.size()];
        int nIndex = 0;
        StringBuilder aResourceID = new StringBuilder(PREFIX_SYNTHETIC);
        for (IReadableResource aResource : aRealResources) {
            if (nIndex > 0) {
                aResourceID.append(';');
            }
            aResourceID.append(aResource.getResourceID());
            aSources[nIndex++] = TransformSourceFactory.create(aResource);
        }
        return this._getSchema(aResourceID.toString(), aSources);
    }

    @Nonnull
    public final Schema getSchema(IReadableResource ... aResources) {
        if (ArrayHelper.isEmpty(aResources)) {
            throw new IllegalArgumentException("no resources provided!");
        }
        return this._getSchema(ContainerHelper.newOrderedSet(aResources));
    }

    @Nonnull
    public final Schema getSchema(@Nonnull @Nonempty List<? extends IReadableResource> aResources) {
        if (ContainerHelper.isEmpty(aResources)) {
            throw new IllegalArgumentException("no resources provided!");
        }
        return this._getSchema(ContainerHelper.newOrderedSet(aResources));
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived(super.toString()).append("schemaTypeName", this.m_sSchemaTypeName).toString();
    }

    @Nonnull
    public static final Validator getValidatorFromSchema(@Nonnull Schema aSchema) {
        if (aSchema == null) {
            throw new NullPointerException("schema");
        }
        Validator aValidator = aSchema.newValidator();
        aValidator.setErrorHandler(LoggingSAXErrorHandler.getInstance());
        return aValidator;
    }
}

