/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.xml.sax;

import com.phloc.commons.io.streams.NonBlockingStringReader;
import com.phloc.commons.string.ToStringGenerator;
import java.io.Reader;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.xml.sax.InputSource;

public final class StringSAXInputSource
extends InputSource {
    private final String m_sText;

    public StringSAXInputSource(@Nonnull String sText) {
        this(sText, null);
    }

    public StringSAXInputSource(@Nonnull String sText, @Nullable String sSystemID) {
        if (sText == null) {
            throw new NullPointerException("text");
        }
        this.m_sText = sText;
        this.setSystemId(sSystemID);
    }

    @Override
    public Reader getCharacterStream() {
        return new NonBlockingStringReader(this.m_sText);
    }

    public String toString() {
        return new ToStringGenerator(this).append("text", this.m_sText).append("systemID", this.getSystemId()).toString();
    }
}

