/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.xml.sax;

import com.phloc.commons.io.IInputStreamProvider;
import com.phloc.commons.io.IReadableResource;
import com.phloc.commons.string.ToStringGenerator;
import java.io.InputStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;

public final class ReadableResourceSAXInputSource
extends InputSource {
    private static final Logger s_aLogger = LoggerFactory.getLogger(ReadableResourceSAXInputSource.class);
    private final IInputStreamProvider m_aISP;

    public ReadableResourceSAXInputSource(@Nonnull IReadableResource aResource) {
        this(aResource, aResource.getResourceID());
    }

    public ReadableResourceSAXInputSource(@Nonnull IInputStreamProvider aISP, @Nullable String sSystemID) {
        if (aISP == null) {
            throw new NullPointerException("resource");
        }
        this.m_aISP = aISP;
        this.setSystemId(sSystemID);
    }

    @Override
    public InputStream getByteStream() {
        InputStream aIS = this.m_aISP.getInputStream();
        if (aIS == null) {
            s_aLogger.warn("Failed to open input stream for " + this.m_aISP);
        }
        return aIS;
    }

    public String toString() {
        return new ToStringGenerator(this).append("resource", this.m_aISP).append("systemID", this.getSystemId()).toString();
    }
}

