/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.thirdparty;

import com.phloc.commons.annotations.Nonempty;
import com.phloc.commons.equals.EqualsUtils;
import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.string.StringHelper;
import com.phloc.commons.string.ToStringGenerator;
import com.phloc.commons.thirdparty.ILicense;
import com.phloc.commons.version.Version;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class CustomLicense
implements ILicense {
    private final String m_sID;
    private final String m_sName;
    private final Version m_aVersion;
    private final String m_sWebSiteURL;

    public CustomLicense(@Nonnull @Nonempty String sID, @Nonnull @Nonempty String sName, @Nullable Version aVersion, @Nullable String sURL) {
        if (StringHelper.hasNoText(sID)) {
            throw new IllegalArgumentException("ID");
        }
        if (StringHelper.hasNoText(sName)) {
            throw new IllegalArgumentException("name");
        }
        this.m_sID = sID;
        this.m_sName = sName;
        this.m_aVersion = aVersion;
        this.m_sWebSiteURL = sURL;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getID() {
        return this.m_sID;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getDisplayName() {
        return this.m_sName;
    }

    @Override
    @Nullable
    public Version getVersion() {
        return this.m_aVersion;
    }

    @Override
    @Nullable
    public String getURL() {
        return this.m_sWebSiteURL;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CustomLicense)) {
            return false;
        }
        CustomLicense rhs = (CustomLicense)o;
        return this.m_sID.equals(rhs.m_sID) && this.m_sName.equals(rhs.m_sName) && EqualsUtils.equals(this.m_aVersion, rhs.m_aVersion) && EqualsUtils.equals(this.m_sWebSiteURL, rhs.m_sWebSiteURL);
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_sID).append(this.m_sName).append(this.m_aVersion).append(this.m_sWebSiteURL).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("ID", this.m_sID).append("name", this.m_sName).appendIfNotNull("version", this.m_aVersion).appendIfNotNull("website", this.m_sWebSiteURL).toString();
    }
}

