/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.text.utils;

import com.phloc.commons.string.ToStringGenerator;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class StringScanner {
    private final String m_sInput;
    private final int m_nMaxIndex;
    private int m_nCurIndex = 0;

    public StringScanner(@Nonnull String sInput) {
        if (sInput == null) {
            throw new NullPointerException("input");
        }
        this.m_sInput = sInput;
        this.m_nMaxIndex = sInput.length();
    }

    @Nonnegative
    public int getCurrentIndex() {
        return this.m_nCurIndex;
    }

    @Nonnegative
    public int getRemainingChars() {
        return this.m_nMaxIndex - this.m_nCurIndex;
    }

    @Nonnull
    public StringScanner skipWhitespaces() {
        while (this.m_nCurIndex < this.m_nMaxIndex && Character.isWhitespace(this.getCurrentChar())) {
            ++this.m_nCurIndex;
        }
        return this;
    }

    @Nonnull
    public StringScanner skipbackWhitespaces() {
        while (this.m_nCurIndex > 0 && this.m_nCurIndex < this.m_nMaxIndex && Character.isWhitespace(this.getCurrentChar())) {
            --this.m_nCurIndex;
        }
        return this;
    }

    @Nonnull
    public StringScanner skip(int nCount) {
        this.m_nCurIndex = Math.min(Math.max(this.m_nCurIndex + nCount, 0), this.m_nMaxIndex);
        return this;
    }

    public int findFirstIndex(char ... aChars) {
        int ret = -1;
        for (char c : aChars) {
            int nIndex = this.m_sInput.indexOf(c, this.m_nCurIndex);
            if (nIndex == -1 || ret != -1 && nIndex >= ret) continue;
            ret = nIndex;
        }
        return ret;
    }

    public char getCharAtIndex(int nIndex) {
        try {
            return this.m_sInput.charAt(nIndex);
        }
        catch (StringIndexOutOfBoundsException ex) {
            throw new IllegalArgumentException("At end of string: position " + nIndex + " of " + this.m_nMaxIndex);
        }
    }

    public char getCurrentChar() {
        return this.getCharAtIndex(this.m_nCurIndex);
    }

    public boolean isCurrentChar(char c) {
        return this.getCurrentChar() == c;
    }

    @Nonnull
    public StringScanner setIndex(@Nonnegative int nIndex) {
        if (nIndex < 0 || nIndex > this.m_nMaxIndex) {
            throw new IllegalArgumentException("The passed index " + nIndex + " must be between 0 and < " + this.m_nMaxIndex);
        }
        this.m_nCurIndex = nIndex;
        return this;
    }

    @Nonnull
    public String getRest() {
        String ret = this.m_sInput.substring(this.m_nCurIndex);
        this.m_nCurIndex = this.m_nMaxIndex;
        return ret;
    }

    @Nonnull
    public String getUntilIndex(int nEndIndex) {
        String ret = this.m_sInput.substring(this.m_nCurIndex, nEndIndex);
        this.setIndex(nEndIndex);
        return ret;
    }

    @Nonnull
    public String getUntilWhiteSpace() {
        int nStart = this.m_nCurIndex;
        while (this.m_nCurIndex < this.m_nMaxIndex && !Character.isWhitespace(this.getCurrentChar())) {
            ++this.m_nCurIndex;
        }
        return this.m_sInput.substring(nStart, this.m_nCurIndex);
    }

    @Nonnull
    public String getUntil(char cEndExcl) {
        int nStart = this.m_nCurIndex;
        while (this.m_nCurIndex < this.m_nMaxIndex && this.getCurrentChar() != cEndExcl) {
            ++this.m_nCurIndex;
        }
        return this.m_sInput.substring(nStart, this.m_nCurIndex);
    }

    @Nonnull
    public String getUntilBalanced(int nStartLevel, char cOpenChar, char cCloseChar) {
        int nStart = this.m_nCurIndex;
        int nLevel = nStartLevel;
        while (this.m_nCurIndex < this.m_nMaxIndex && nLevel > 0) {
            char aChar = this.getCurrentChar();
            if (aChar == cOpenChar) {
                ++nLevel;
            } else if (aChar == cCloseChar) {
                --nLevel;
            }
            ++this.m_nCurIndex;
        }
        if (this.m_nCurIndex == nStart) {
            return "";
        }
        return this.m_sInput.substring(nStart, this.m_nCurIndex - 1);
    }

    public String toString() {
        return new ToStringGenerator(this).append("input", this.m_sInput).append("curIndex", this.m_nCurIndex).append("maxIndex", this.m_nMaxIndex).toString();
    }
}

