/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.text.utils;

import com.phloc.commons.string.StringHelper;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class RomanNumeral {
    public static final int MIN_VAL = 1;
    public static final int MAX_VAL = 3999;
    private static final int[] NUMBERS = new int[]{1000, 900, 500, 400, 100, 90, 50, 40, 10, 9, 5, 4, 1};
    private static final String[] ROMAN_LETTERS = new String[]{"M", "CM", "D", "CD", "C", "XC", "L", "XL", "X", "IX", "V", "IV", "I"};
    private final int m_nValue;

    private RomanNumeral(@Nonnegative int nValue) {
        if (nValue < 1 || nValue > 3999) {
            throw new IllegalArgumentException("Value of RomanNumeral must be between 1 and 3999.");
        }
        this.m_nValue = nValue;
    }

    private RomanNumeral(@Nonnull String sRoman) {
        if (StringHelper.hasNoText(sRoman)) {
            throw new IllegalArgumentException("An empty string does not define a Roman numeral.");
        }
        String sRealRoman = sRoman.toUpperCase();
        int nIndex = 0;
        int nArabic = 0;
        while (nIndex < sRealRoman.length()) {
            char cLetter = sRealRoman.charAt(nIndex);
            int nNumber = RomanNumeral._letterToNumber(cLetter);
            if (++nIndex == sRealRoman.length()) {
                nArabic += nNumber;
                continue;
            }
            int nNextNumber = RomanNumeral._letterToNumber(sRealRoman.charAt(nIndex));
            if (nNextNumber > nNumber) {
                nArabic += nNextNumber - nNumber;
                ++nIndex;
                continue;
            }
            nArabic += nNumber;
        }
        if (nArabic > 3999) {
            throw new IllegalArgumentException("Roman numeral must have value 3999 or less.");
        }
        this.m_nValue = nArabic;
    }

    @Nonnegative
    private static int _letterToNumber(char cLetter) {
        switch (cLetter) {
            case 'I': {
                return 1;
            }
            case 'V': {
                return 5;
            }
            case 'X': {
                return 10;
            }
            case 'L': {
                return 50;
            }
            case 'C': {
                return 100;
            }
            case 'D': {
                return 500;
            }
            case 'M': {
                return 1000;
            }
        }
        throw new IllegalArgumentException("Unknown roman numeral char: " + cLetter);
    }

    @Nonnull
    private static String _asRomanString(int nValue) {
        StringBuilder aSB = new StringBuilder();
        int nWorkValue = nValue;
        for (int i = 0; i < NUMBERS.length; ++i) {
            while (nWorkValue >= NUMBERS[i]) {
                aSB.append(ROMAN_LETTERS[i]);
                nWorkValue -= NUMBERS[i];
            }
        }
        return aSB.toString();
    }

    @Nonnull
    private String _asRomanString() {
        return RomanNumeral._asRomanString(this.m_nValue);
    }

    private int _asInt() {
        return this.m_nValue;
    }

    @Nonnegative
    public static int romanStringToInt(String sRoman) {
        return new RomanNumeral(sRoman)._asInt();
    }

    @Nonnull
    public static String intToRomanString(int nValue) {
        return new RomanNumeral(nValue)._asRomanString();
    }
}

