/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.stats.utils;

import com.phloc.commons.collections.ContainerHelper;
import com.phloc.commons.microdom.IMicroElement;
import com.phloc.commons.stats.IStatisticsHandlerCache;
import com.phloc.commons.stats.IStatisticsHandlerCounter;
import com.phloc.commons.stats.IStatisticsHandlerKeyedCounter;
import com.phloc.commons.stats.IStatisticsHandlerKeyedSize;
import com.phloc.commons.stats.IStatisticsHandlerKeyedTimer;
import com.phloc.commons.stats.IStatisticsHandlerSize;
import com.phloc.commons.stats.IStatisticsHandlerTimer;
import com.phloc.commons.stats.visit.IStatisticsVisitor;
import javax.annotation.Nonnull;

public final class StatisticsVisitorToXML
implements IStatisticsVisitor {
    private final IMicroElement m_eRoot;

    public StatisticsVisitorToXML(@Nonnull IMicroElement eRoot) {
        if (eRoot == null) {
            throw new NullPointerException("root");
        }
        this.m_eRoot = eRoot;
    }

    @Override
    public void onCache(String sName, IStatisticsHandlerCache aHandler) {
        if (aHandler.getInvocationCount() > 0) {
            this.m_eRoot.appendElement("cache").setAttribute("name", sName).setAttribute("invocationcount", Integer.toString(aHandler.getInvocationCount())).setAttribute("hits", Integer.toString(aHandler.getHits())).setAttribute("misses", Integer.toString(aHandler.getMisses()));
        }
    }

    @Override
    public void onTimer(String sName, IStatisticsHandlerTimer aHandler) {
        if (aHandler.getInvocationCount() > 0) {
            this.m_eRoot.appendElement("timer").setAttribute("name", sName).setAttribute("invocationcount", Integer.toString(aHandler.getInvocationCount())).setAttribute("min", Long.toString(aHandler.getMin())).setAttribute("average", Long.toString(aHandler.getAverage())).setAttribute("max", Long.toString(aHandler.getMax())).setAttribute("sum", aHandler.getSum().toString());
        }
    }

    @Override
    public void onKeyedTimer(String sName, IStatisticsHandlerKeyedTimer aHandler) {
        if (aHandler.getInvocationCount() > 0) {
            IMicroElement eKeyedTimer = this.m_eRoot.appendElement("keyedtimer").setAttribute("name", sName).setAttribute("invocationcount", Integer.toString(aHandler.getInvocationCount()));
            for (String sKey : ContainerHelper.getSorted(aHandler.getAllKeys())) {
                eKeyedTimer.appendElement("key").setAttribute("name", sKey).setAttribute("invocationcount", Integer.toString(aHandler.getInvocationCount(sKey))).setAttribute("min", Long.toString(aHandler.getMin(sKey))).setAttribute("average", Long.toString(aHandler.getAverage(sKey))).setAttribute("max", Long.toString(aHandler.getMax(sKey))).setAttribute("sum", aHandler.getSum(sKey).toString());
            }
        }
    }

    @Override
    public void onSize(String sName, IStatisticsHandlerSize aHandler) {
        if (aHandler.getInvocationCount() > 0) {
            this.m_eRoot.appendElement("size").setAttribute("name", sName).setAttribute("invocationcount", Integer.toString(aHandler.getInvocationCount())).setAttribute("min", Long.toString(aHandler.getMin())).setAttribute("average", Long.toString(aHandler.getAverage())).setAttribute("max", Long.toString(aHandler.getMax())).setAttribute("sum", aHandler.getSum().toString());
        }
    }

    @Override
    public void onKeyedSize(String sName, IStatisticsHandlerKeyedSize aHandler) {
        if (aHandler.getInvocationCount() > 0) {
            IMicroElement eKeyedSize = this.m_eRoot.appendElement("keyedsize").setAttribute("name", sName).setAttribute("invocationcount", Integer.toString(aHandler.getInvocationCount()));
            for (String sKey : ContainerHelper.getSorted(aHandler.getAllKeys())) {
                eKeyedSize.appendElement("key").setAttribute("name", sKey).setAttribute("invocationcount", Integer.toString(aHandler.getInvocationCount(sKey))).setAttribute("min", Long.toString(aHandler.getMin(sKey))).setAttribute("average", Long.toString(aHandler.getAverage(sKey))).setAttribute("max", Long.toString(aHandler.getMax(sKey))).setAttribute("sum", aHandler.getSum(sKey).toString());
            }
        }
    }

    @Override
    public void onCounter(String sName, IStatisticsHandlerCounter aHandler) {
        if (aHandler.getInvocationCount() > 0) {
            this.m_eRoot.appendElement("counter").setAttribute("name", sName).setAttribute("invocationcount", Integer.toString(aHandler.getInvocationCount())).setAttribute("count", Long.toString(aHandler.getCount()));
        }
    }

    @Override
    public void onKeyedCounter(String sName, IStatisticsHandlerKeyedCounter aHandler) {
        if (aHandler.getInvocationCount() > 0) {
            IMicroElement eKeyedCounter = this.m_eRoot.appendElement("keyedcounter").setAttribute("name", sName).setAttribute("invocationcount", Integer.toString(aHandler.getInvocationCount()));
            for (String sKey : ContainerHelper.getSorted(aHandler.getAllKeys())) {
                eKeyedCounter.appendElement("key").setAttribute("name", sKey).setAttribute("invocationcount", Integer.toString(aHandler.getInvocationCount(sKey))).setAttribute("count", Long.toString(aHandler.getCount(sKey)));
            }
        }
    }
}

