/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.state;

import com.phloc.commons.annotations.Nonempty;
import com.phloc.commons.id.IHasID;
import com.phloc.commons.lang.EnumHelper;
import com.phloc.commons.state.ITriState;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public enum ETriState implements IHasID<String>,
ITriState
{
    TRUE("true", Boolean.TRUE),
    FALSE("false", Boolean.FALSE),
    UNDEFINED("undefined", null);

    private final String m_sID;
    private final Boolean m_aBoolean;

    private ETriState(String sID, Boolean aBoolean) {
        this.m_sID = sID;
        this.m_aBoolean = aBoolean;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getID() {
        return this.m_sID;
    }

    @Override
    public boolean isTrue() {
        return this == TRUE;
    }

    @Override
    public boolean isFalse() {
        return this == FALSE;
    }

    @Override
    public boolean isUndefined() {
        return this == UNDEFINED;
    }

    @Override
    public boolean getAsBooleanValue(boolean bUndefinedValue) {
        return this == UNDEFINED ? bUndefinedValue : this.m_aBoolean;
    }

    @Nullable
    public Boolean getAsBooleanObj(boolean aUndefinedValue) {
        return this.getAsBooleanObj((Boolean)aUndefinedValue);
    }

    @Override
    @Nullable
    public Boolean getAsBooleanObj(@Nullable Boolean aUndefinedValue) {
        return this == UNDEFINED ? aUndefinedValue : this.m_aBoolean;
    }

    @Nonnull
    public static ETriState valueOf(boolean bValue) {
        return bValue ? TRUE : FALSE;
    }

    @Nonnull
    public static ETriState valueOf(@Nullable Boolean aValue) {
        return aValue == null ? UNDEFINED : ETriState.valueOf((boolean)aValue);
    }

    @Nonnull
    public static ETriState valueOf(@Nonnull ITriState aTriState) {
        return ETriState.valueOf(aTriState.getAsBooleanObj(null));
    }

    @Nullable
    public static ETriState getFromIDOrNull(@Nullable String sID) {
        return EnumHelper.getFromIDOrNull(ETriState.class, sID);
    }

    @Nonnull
    public static ETriState getFromIDOrUndefined(@Nullable String sID) {
        return ETriState.getFromIDOrDefault(sID, UNDEFINED);
    }

    @Nullable
    public static ETriState getFromIDOrDefault(@Nullable String sID, @Nullable ETriState eDefault) {
        return EnumHelper.getFromIDOrDefault(ETriState.class, sID, eDefault);
    }
}

