/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.parent.impl;

import com.phloc.commons.collections.ContainerHelper;
import com.phloc.commons.parent.IChildrenProvider;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public class ChildrenProviderSorting<CHILDTYPE>
implements IChildrenProvider<CHILDTYPE> {
    protected final IChildrenProvider<CHILDTYPE> m_aCR;
    private final Comparator<? super CHILDTYPE> m_aComparator;

    public ChildrenProviderSorting(@Nonnull IChildrenProvider<CHILDTYPE> aCP, @Nonnull Comparator<? super CHILDTYPE> aComparator) {
        if (aCP == null) {
            throw new NullPointerException("childrenProvider");
        }
        if (aComparator == null) {
            throw new NullPointerException("comparator");
        }
        this.m_aCR = aCP;
        this.m_aComparator = aComparator;
    }

    @Override
    public final boolean hasChildren(@Nullable CHILDTYPE aCurrent) {
        return this.m_aCR.hasChildren(aCurrent);
    }

    @Override
    public final int getChildCount(@Nullable CHILDTYPE aCurrent) {
        return this.m_aCR.getChildCount(aCurrent);
    }

    @Override
    @Nullable
    public List<? extends CHILDTYPE> getChildren(@Nullable CHILDTYPE aCurrent) {
        Collection<CHILDTYPE> ret = this.m_aCR.getChildren(aCurrent);
        return ret == null ? null : ContainerHelper.getSorted(ret, this.m_aComparator);
    }
}

