/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.microdom.impl;

import com.phloc.commons.annotations.Nonempty;
import com.phloc.commons.annotations.OverrideOnDemand;
import com.phloc.commons.collections.ContainerHelper;
import com.phloc.commons.microdom.EMicroEvent;
import com.phloc.commons.microdom.IMicroCDATA;
import com.phloc.commons.microdom.IMicroComment;
import com.phloc.commons.microdom.IMicroContainer;
import com.phloc.commons.microdom.IMicroDocument;
import com.phloc.commons.microdom.IMicroDocumentType;
import com.phloc.commons.microdom.IMicroElement;
import com.phloc.commons.microdom.IMicroEntityReference;
import com.phloc.commons.microdom.IMicroEvent;
import com.phloc.commons.microdom.IMicroEventTarget;
import com.phloc.commons.microdom.IMicroNode;
import com.phloc.commons.microdom.IMicroProcessingInstruction;
import com.phloc.commons.microdom.IMicroText;
import com.phloc.commons.microdom.MicroException;
import com.phloc.commons.microdom.impl.AbstractMicroNodeWithChildren;
import com.phloc.commons.microdom.impl.MicroCDATA;
import com.phloc.commons.microdom.impl.MicroComment;
import com.phloc.commons.microdom.impl.MicroContainer;
import com.phloc.commons.microdom.impl.MicroElement;
import com.phloc.commons.microdom.impl.MicroEntityReference;
import com.phloc.commons.microdom.impl.MicroEvent;
import com.phloc.commons.microdom.impl.MicroProcessingInstruction;
import com.phloc.commons.microdom.impl.MicroText;
import com.phloc.commons.state.EChange;
import com.phloc.commons.string.ToStringGenerator;
import com.phloc.commons.typeconvert.TypeConverter;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class AbstractMicroNode
implements IMicroNode {
    private AbstractMicroNodeWithChildren m_aParentNode;
    private Map<EMicroEvent, Set<IMicroEventTarget>> m_aEventTargets;

    @Override
    @OverrideOnDemand
    public String getNodeValue() {
        return "";
    }

    @OverrideOnDemand
    protected void onAppendChild(@Nonnull AbstractMicroNode aChildNode) {
        throw new MicroException("Cannot append children in class " + this.getClass().getName());
    }

    @OverrideOnDemand
    protected void onInsertBefore(@Nonnull AbstractMicroNode aChildNode, @Nonnull IMicroNode aSuccessor) {
        throw new MicroException("Cannot insert children in class " + this.getClass().getName());
    }

    @OverrideOnDemand
    protected void onInsertAfter(@Nonnull AbstractMicroNode aChildNode, @Nonnull IMicroNode aPredecessor) {
        throw new MicroException("Cannot insert children in class " + this.getClass().getName());
    }

    @OverrideOnDemand
    protected void onInsertAtIndex(@Nonnegative int nIndex, @Nonnull AbstractMicroNode aChildNode) {
        throw new MicroException("Cannot insert children in class " + this.getClass().getName());
    }

    @Override
    @Nullable
    public final <NODETYPE extends IMicroNode> NODETYPE appendChild(@Nullable NODETYPE aChildNode) {
        if (aChildNode != null) {
            this.onAppendChild((AbstractMicroNode)aChildNode);
        }
        return aChildNode;
    }

    @Override
    @Nullable
    public final <NODETYPE extends IMicroNode> NODETYPE insertBefore(@Nullable NODETYPE aChildNode, @Nonnull IMicroNode aSuccessor) {
        if (aChildNode != null) {
            this.onInsertBefore((AbstractMicroNode)aChildNode, aSuccessor);
        }
        return aChildNode;
    }

    @Override
    @Nullable
    public final <NODETYPE extends IMicroNode> NODETYPE insertAfter(@Nullable NODETYPE aChildNode, @Nonnull IMicroNode aPredecessor) {
        if (aChildNode != null) {
            this.onInsertAfter((AbstractMicroNode)aChildNode, aPredecessor);
        }
        return aChildNode;
    }

    @Override
    @Nullable
    public final <NODETYPE extends IMicroNode> NODETYPE insertAtIndex(@Nonnegative int nIndex, @Nullable NODETYPE aChildNode) {
        if (aChildNode != null) {
            this.onInsertAtIndex(nIndex, (AbstractMicroNode)aChildNode);
        }
        return aChildNode;
    }

    @Override
    @Nonnull
    public final IMicroText appendText(@Nullable CharSequence sText) {
        MicroText aNode = new MicroText(sText, false);
        this.onAppendChild(aNode);
        return aNode;
    }

    @Override
    @Nonnull
    public final IMicroText appendTextWithConversion(@Nullable Object aValue) {
        String sValue = TypeConverter.convertIfNecessary(aValue, String.class);
        return this.appendText(sValue);
    }

    @Override
    @Nonnull
    public final IMicroText appendIgnorableWhitespaceText(@Nullable CharSequence sText) {
        MicroText aNode = new MicroText(sText, true);
        this.onAppendChild(aNode);
        return aNode;
    }

    @Override
    @Nonnull
    public final IMicroCDATA appendCDATA(@Nullable CharSequence sText) {
        MicroCDATA aNode = new MicroCDATA(sText);
        this.onAppendChild(aNode);
        return aNode;
    }

    @Override
    @Nonnull
    public final IMicroComment appendComment(@Nullable CharSequence sText) {
        MicroComment aNode = new MicroComment(sText);
        this.onAppendChild(aNode);
        return aNode;
    }

    @Override
    @Nonnull
    public final IMicroEntityReference appendEntityReference(@Nonnull @Nonempty String sName) {
        MicroEntityReference aNode = new MicroEntityReference(sName);
        this.onAppendChild(aNode);
        return aNode;
    }

    @Override
    @Nonnull
    public final IMicroElement appendElement(@Nonnull @Nonempty String sTagName) {
        return this.appendElement(null, sTagName);
    }

    @Override
    @Nonnull
    public final IMicroElement appendElement(@Nullable String sNamespaceURI, @Nonnull @Nonempty String sTagName) {
        MicroElement aNode = new MicroElement(sNamespaceURI, sTagName);
        this.onAppendChild(aNode);
        return aNode;
    }

    @Override
    @Nonnull
    public final IMicroProcessingInstruction appendProcessingInstruction(@Nonnull @Nonempty String sTarget, @Nullable String sData) {
        MicroProcessingInstruction aNode = new MicroProcessingInstruction(sTarget, sData);
        this.onAppendChild(aNode);
        return aNode;
    }

    @Override
    @Nonnull
    public final IMicroContainer appendContainer() {
        MicroContainer aNode = new MicroContainer();
        this.onAppendChild(aNode);
        return aNode;
    }

    @Nonnull
    @OverrideOnDemand
    protected EChange onRemoveChild(IMicroNode aChild) {
        throw new MicroException("Cannot remove child from this node: " + this.getClass().getName());
    }

    @Override
    @Nonnull
    public final EChange removeChild(@Nonnull IMicroNode aChild) {
        if (aChild == null) {
            throw new NullPointerException("child");
        }
        return this.onRemoveChild(aChild);
    }

    @Nonnull
    @OverrideOnDemand
    protected EChange onRemoveChildAtIndex(int nIndex) {
        throw new MicroException("Cannot remove child from this node: " + this.getClass().getName());
    }

    @Override
    @Nonnull
    public final EChange removeChildAtIndex(@Nonnegative int nIndex) {
        return this.onRemoveChildAtIndex(nIndex);
    }

    @Nonnull
    @OverrideOnDemand
    protected EChange onRemoveAllChildren() {
        throw new MicroException("Cannot remove all children from this node: " + this.getClass().getName());
    }

    @Override
    @Nonnull
    public final EChange removeAllChildren() {
        return this.onRemoveAllChildren();
    }

    @Override
    @Nonnull
    public final EChange replaceChild(@Nonnull IMicroNode aOldChild, @Nonnull IMicroNode aNewChild) {
        if (aOldChild == null) {
            throw new NullPointerException("oldChild");
        }
        if (aNewChild == null) {
            throw new NullPointerException("newChild");
        }
        if (aOldChild.equals(aNewChild)) {
            return EChange.UNCHANGED;
        }
        this.insertBefore(aNewChild, aOldChild);
        this.removeChild(aOldChild);
        return EChange.CHANGED;
    }

    @Override
    @OverrideOnDemand
    public boolean hasChildren() {
        return false;
    }

    @Override
    @Nullable
    @OverrideOnDemand
    public List<IMicroNode> getChildren() {
        return null;
    }

    @Override
    @Nullable
    @OverrideOnDemand
    public IMicroNode getChildAtIndex(@Nonnegative int nIndex) {
        return null;
    }

    @Override
    @Nonnegative
    @OverrideOnDemand
    public int getChildCount() {
        return 0;
    }

    @Override
    @Nullable
    @OverrideOnDemand
    public IMicroNode getFirstChild() {
        return null;
    }

    @Override
    @Nullable
    @OverrideOnDemand
    public IMicroNode getLastChild() {
        return null;
    }

    @Override
    @Nullable
    @OverrideOnDemand
    public List<IMicroNode> getAllChildrenRecursive() {
        return null;
    }

    @Override
    @Nullable
    public final IMicroNode getPreviousSibling() {
        if (this.m_aParentNode == null) {
            return null;
        }
        List<IMicroNode> aParentChildren = this.m_aParentNode.directGetChildren();
        int nIndex = aParentChildren.indexOf(this);
        if (nIndex == -1) {
            throw new IllegalStateException("this is no part of it's parents children");
        }
        return ContainerHelper.getSafe(aParentChildren, nIndex - 1);
    }

    @Override
    @Nullable
    public final IMicroNode getNextSibling() {
        if (this.m_aParentNode == null) {
            return null;
        }
        List<IMicroNode> aParentChildren = this.m_aParentNode.directGetChildren();
        int nIndex = aParentChildren.indexOf(this);
        if (nIndex == -1) {
            throw new IllegalStateException("this is no part of it's parents children");
        }
        return ContainerHelper.getSafe(aParentChildren, nIndex + 1);
    }

    @Override
    public final boolean hasParent() {
        return this.m_aParentNode != null;
    }

    @Override
    @Nullable
    public final IMicroNode getParent() {
        return this.m_aParentNode;
    }

    final void resetParentNode() {
        this.m_aParentNode = null;
    }

    final void setParentNode(@Nonnull AbstractMicroNodeWithChildren aParentNode) {
        if (aParentNode == null) {
            throw new MicroException("No parent node passed!");
        }
        if (aParentNode == this) {
            throw new MicroException("Node cannot have itself as parent: " + this.toString());
        }
        if (this.m_aParentNode != null) {
            throw new MicroException("Node already has a parent: " + this.toString());
        }
        this.m_aParentNode = aParentNode;
    }

    @Override
    @Nonnull
    public final IMicroNode detachFromParent() {
        if (this.m_aParentNode != null) {
            if (this.m_aParentNode.removeChild(this).isUnchanged()) {
                throw new IllegalStateException("Failed to remove this from parents child list");
            }
            this.resetParentNode();
        }
        return this;
    }

    @Override
    @Nullable
    public final IMicroElement getParentElementWithName(@Nullable String sTagName) {
        for (IMicroNode aParent = this.m_aParentNode; aParent != null && aParent.isElement(); aParent = aParent.getParent()) {
            IMicroElement aParentElement = (IMicroElement)aParent;
            if (!aParentElement.getTagName().equals(sTagName)) continue;
            return aParentElement;
        }
        return null;
    }

    @Override
    @Nullable
    public final IMicroElement getParentElementWithName(@Nullable String sNamespaceURI, @Nullable String sTagName) {
        for (IMicroNode aParent = this.m_aParentNode; aParent != null && aParent.isElement(); aParent = aParent.getParent()) {
            IMicroElement aParentElement = (IMicroElement)aParent;
            if (!aParentElement.hasNamespaceURI(sNamespaceURI) || !aParentElement.getTagName().equals(sTagName)) continue;
            return aParentElement;
        }
        return null;
    }

    @Override
    public final boolean isDocument() {
        return this instanceof IMicroDocument;
    }

    @Override
    public final boolean isDocumentType() {
        return this instanceof IMicroDocumentType;
    }

    @Override
    public final boolean isText() {
        return this instanceof IMicroText;
    }

    @Override
    public final boolean isCDATA() {
        return this instanceof IMicroCDATA;
    }

    @Override
    public final boolean isComment() {
        return this instanceof IMicroComment;
    }

    @Override
    public final boolean isEntityReference() {
        return this instanceof IMicroEntityReference;
    }

    @Override
    public final boolean isElement() {
        return this instanceof IMicroElement;
    }

    @Override
    public final boolean isProcessingInstruction() {
        return this instanceof IMicroProcessingInstruction;
    }

    @Override
    public final boolean isContainer() {
        return this instanceof IMicroContainer;
    }

    final void internalTriggerEvent(@Nonnull EMicroEvent eEventType, @Nonnull IMicroEvent aEvent) {
        Set<IMicroEventTarget> aTargets;
        if (this.m_aEventTargets != null && !this.m_aEventTargets.isEmpty() && (aTargets = this.m_aEventTargets.get(eEventType)) != null && !aTargets.isEmpty()) {
            for (IMicroEventTarget aTarget : aTargets) {
                aTarget.handleEvent(aEvent);
            }
        }
        if (this.m_aParentNode != null) {
            this.m_aParentNode.internalTriggerEvent(eEventType, aEvent);
        }
    }

    protected final void onEvent(@Nonnull EMicroEvent eEventType, @Nonnull IMicroNode aSourceNode, @Nonnull IMicroNode aTargetNode) {
        this.internalTriggerEvent(eEventType, new MicroEvent(eEventType, aSourceNode, aTargetNode));
    }

    @Override
    @Nonnull
    public EChange registerEventTarget(@Nonnull EMicroEvent eEventType, @Nonnull IMicroEventTarget aTarget) {
        Set<IMicroEventTarget> aSet;
        if (eEventType == null) {
            throw new NullPointerException("eventType");
        }
        if (aTarget == null) {
            throw new NullPointerException("eventTarget");
        }
        if (this.m_aEventTargets == null) {
            this.m_aEventTargets = new HashMap<EMicroEvent, Set<IMicroEventTarget>>();
        }
        if ((aSet = this.m_aEventTargets.get(eEventType)) == null) {
            aSet = new LinkedHashSet<IMicroEventTarget>();
            this.m_aEventTargets.put(eEventType, aSet);
        }
        return EChange.valueOf(aSet.add(aTarget));
    }

    @Override
    @Nonnull
    public EChange unregisterEventTarget(@Nonnull EMicroEvent eEventType, @Nonnull IMicroEventTarget aTarget) {
        Set<IMicroEventTarget> aSet;
        if (eEventType == null) {
            throw new NullPointerException("eventType");
        }
        if (aTarget == null) {
            throw new NullPointerException("eventTarget");
        }
        if (this.m_aEventTargets != null && !this.m_aEventTargets.isEmpty() && (aSet = this.m_aEventTargets.get(eEventType)) != null && !aSet.isEmpty()) {
            return EChange.valueOf(aSet.remove(aTarget));
        }
        return EChange.UNCHANGED;
    }

    public String toString() {
        return new ToStringGenerator(this).appendIfNotNull("parentNodeName", this.m_aParentNode == null ? null : this.m_aParentNode.getNodeName()).appendIfNotNull("eventTargets", this.m_aEventTargets).toString();
    }
}

