/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.io.streams;

import com.phloc.commons.SystemProperties;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.Writer;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class NonBlockingBufferedWriter
extends Writer {
    private static final int DEFAULT_CHAR_BUFFER_SIZE = 8192;
    private Writer m_aWriter;
    private char[] m_aBuf;
    private final int m_nChars;
    private int m_nNextChar;
    private final String m_sLineSeparator;

    public NonBlockingBufferedWriter(@Nonnull Writer aWriter) {
        this(aWriter, 8192);
    }

    public NonBlockingBufferedWriter(@Nonnull Writer aWriter, int nBufSize) {
        super((Object)aWriter);
        if (nBufSize <= 0) {
            throw new IllegalArgumentException("Buffer size <= 0");
        }
        this.m_aWriter = aWriter;
        this.m_aBuf = new char[nBufSize];
        this.m_nChars = nBufSize;
        this.m_nNextChar = 0;
        this.m_sLineSeparator = SystemProperties.getLineSeparator();
    }

    private void _ensureOpen() throws IOException {
        if (this.m_aWriter == null) {
            throw new IOException("Stream closed");
        }
    }

    void flushBuffer() throws IOException {
        this._ensureOpen();
        if (this.m_nNextChar != 0) {
            this.m_aWriter.write(this.m_aBuf, 0, this.m_nNextChar);
            this.m_nNextChar = 0;
        }
    }

    @Override
    public void write(int c) throws IOException {
        this._ensureOpen();
        if (this.m_nNextChar >= this.m_nChars) {
            this.flushBuffer();
        }
        this.m_aBuf[this.m_nNextChar++] = (char)c;
    }

    private static int _min(int a, int b) {
        return a < b ? a : b;
    }

    @Override
    @SuppressFBWarnings(value={"IL_INFINITE_LOOP"})
    public void write(char[] cbuf, int off, int len) throws IOException {
        this._ensureOpen();
        if (off < 0 || off > cbuf.length || len < 0 || off + len > cbuf.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        if (len >= this.m_nChars) {
            this.flushBuffer();
            this.m_aWriter.write(cbuf, off, len);
        } else {
            int b = off;
            int t = off + len;
            while (b < t) {
                int d = NonBlockingBufferedWriter._min(this.m_nChars - this.m_nNextChar, t - b);
                System.arraycopy(cbuf, b, this.m_aBuf, this.m_nNextChar, d);
                b += d;
                this.m_nNextChar += d;
                if (this.m_nNextChar < this.m_nChars) continue;
                this.flushBuffer();
            }
        }
    }

    @Override
    @SuppressFBWarnings(value={"IL_INFINITE_LOOP"})
    public void write(String s, int off, int len) throws IOException {
        this._ensureOpen();
        int b = off;
        int t = off + len;
        while (b < t) {
            int d = NonBlockingBufferedWriter._min(this.m_nChars - this.m_nNextChar, t - b);
            s.getChars(b, b + d, this.m_aBuf, this.m_nNextChar);
            b += d;
            this.m_nNextChar += d;
            if (this.m_nNextChar < this.m_nChars) continue;
            this.flushBuffer();
        }
    }

    public void newLine() throws IOException {
        this.write(this.m_sLineSeparator);
    }

    @Override
    public void flush() throws IOException {
        this.flushBuffer();
        this.m_aWriter.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        if (this.m_aWriter != null) {
            try {
                this.flushBuffer();
            }
            finally {
                this.m_aWriter.close();
                this.m_aWriter = null;
                this.m_aBuf = null;
            }
        }
    }
}

