/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.io.streams;

import com.phloc.commons.io.streams.WrappedInputStream;
import com.phloc.commons.messagedigest.EMessageDigestAlgorithm;
import com.phloc.commons.messagedigest.IMessageDigestGenerator;
import com.phloc.commons.messagedigest.NonBlockingMessageDigestGenerator;
import com.phloc.commons.string.ToStringGenerator;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.Nonnull;

public class HashingInputStream
extends WrappedInputStream {
    private final IMessageDigestGenerator m_aMDGen;

    public HashingInputStream(@Nonnull InputStream aSourceIS, @Nonnull EMessageDigestAlgorithm eMDAlgorithm) {
        super(aSourceIS);
        this.m_aMDGen = new NonBlockingMessageDigestGenerator(eMDAlgorithm);
    }

    @Override
    public int read() throws IOException {
        int ret = super.read();
        if (ret != -1) {
            this.m_aMDGen.update((byte)ret);
        }
        return ret;
    }

    @Override
    public int read(byte[] b, int nOffset, int nLength) throws IOException {
        int ret = super.read(b, nOffset, nLength);
        if (ret != -1) {
            this.m_aMDGen.update(b, nOffset, ret);
        }
        return ret;
    }

    @Nonnull
    public byte[] getDigest() {
        return this.m_aMDGen.getDigest();
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived(super.toString()).append("mdgen", this.m_aMDGen).toString();
    }
}

