/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.io.streams;

import com.phloc.commons.io.EAppend;
import com.phloc.commons.stats.IStatisticsHandlerCounter;
import com.phloc.commons.stats.IStatisticsHandlerSize;
import com.phloc.commons.stats.StatisticsManager;
import com.phloc.commons.string.ToStringGenerator;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

public class CountingFileOutputStream
extends FileOutputStream {
    public static final EAppend DEFAULT_APPEND = EAppend.DEFAULT;
    private static final IStatisticsHandlerSize s_aWriteSizeHdl = StatisticsManager.getSizeHandler(CountingFileOutputStream.class.getName() + "$write.bytes");
    private static final IStatisticsHandlerCounter s_aWriteFilesHdl = StatisticsManager.getCounterHandler(CountingFileOutputStream.class.getName() + "$write.files");
    private long m_nBytesWritten = 0L;

    public CountingFileOutputStream(@Nonnull File aFile) throws FileNotFoundException {
        this(aFile, DEFAULT_APPEND);
    }

    public CountingFileOutputStream(@Nonnull File aFile, @Nonnull EAppend eAppend) throws FileNotFoundException {
        super(aFile, eAppend.isAppend());
        s_aWriteFilesHdl.increment();
    }

    public CountingFileOutputStream(@Nonnull String sFilename) throws FileNotFoundException {
        this(sFilename, DEFAULT_APPEND);
    }

    public CountingFileOutputStream(@Nonnull String sFilename, @Nonnull EAppend eAppend) throws FileNotFoundException {
        super(sFilename, eAppend.isAppend());
        s_aWriteFilesHdl.increment();
    }

    @Override
    public void write(int b) throws IOException {
        super.write(b);
        s_aWriteSizeHdl.addSize(1L);
        ++this.m_nBytesWritten;
    }

    @Override
    public void write(byte[] b) throws IOException {
        super.write(b);
        s_aWriteSizeHdl.addSize(b.length);
        this.m_nBytesWritten += (long)b.length;
    }

    @Override
    public void write(byte[] b, int nOffset, int nLength) throws IOException {
        super.write(b, nOffset, nLength);
        s_aWriteSizeHdl.addSize(nLength);
        this.m_nBytesWritten += (long)nLength;
    }

    @Nonnegative
    public long getBytesWritten() {
        return this.m_nBytesWritten;
    }

    public String toString() {
        return ToStringGenerator.getDerived(super.toString()).append("bytesWritten", this.m_nBytesWritten).toString();
    }
}

