/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.io.resourceprovider;

import com.phloc.commons.annotations.OverrideOnDemand;
import com.phloc.commons.collections.ArrayHelper;
import com.phloc.commons.collections.ContainerHelper;
import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.io.IReadableResource;
import com.phloc.commons.io.IReadableResourceProvider;
import com.phloc.commons.string.ToStringGenerator;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public class ReadableResourceProviderChain
implements IReadableResourceProvider {
    protected final List<IReadableResourceProvider> m_aReadingResourceProviders;

    public ReadableResourceProviderChain(IReadableResourceProvider ... aResProviders) {
        if (ArrayHelper.isEmpty(aResProviders)) {
            throw new IllegalArgumentException("No resource provider passed!");
        }
        this.m_aReadingResourceProviders = ContainerHelper.newList(aResProviders);
    }

    @Override
    public final boolean supportsReading(@Nullable String sName) {
        for (IReadableResourceProvider aResProvider : this.m_aReadingResourceProviders) {
            if (!aResProvider.supportsReading(sName)) continue;
            return true;
        }
        return false;
    }

    @Override
    @Nonnull
    @OverrideOnDemand
    public IReadableResource getReadableResource(@Nonnull String sName) {
        for (IReadableResourceProvider aResProvider : this.m_aReadingResourceProviders) {
            if (!aResProvider.supportsReading(sName)) continue;
            return aResProvider.getReadableResource(sName);
        }
        throw new IllegalArgumentException("Cannot handle reading '" + sName + "' by " + this.m_aReadingResourceProviders);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !this.getClass().equals(o.getClass())) {
            return false;
        }
        ReadableResourceProviderChain rhs = (ReadableResourceProviderChain)o;
        return ((Object)this.m_aReadingResourceProviders).equals(rhs.m_aReadingResourceProviders);
    }

    public int hashCode() {
        return ((HashCodeGenerator)new HashCodeGenerator(this).append(this.m_aReadingResourceProviders)).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("resProviders", this.m_aReadingResourceProviders).toString();
    }
}

