/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.io.file.filter;

import com.phloc.commons.collections.ArrayHelper;
import com.phloc.commons.filter.FilterChainAND;
import com.phloc.commons.filter.FilterChainOR;
import com.phloc.commons.filter.IFilter;
import com.phloc.commons.io.file.filter.FileFilterFromFilenameFilter;
import com.phloc.commons.string.ToStringGenerator;
import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class FileFilterToIFilterAdapter
implements IFilter<File> {
    private final FileFilter m_aFileFilter;

    public FileFilterToIFilterAdapter(@Nonnull FilenameFilter aFilenameFilter) {
        this(new FileFilterFromFilenameFilter(aFilenameFilter));
    }

    public FileFilterToIFilterAdapter(@Nonnull FileFilter aFileFilter) {
        if (aFileFilter == null) {
            throw new NullPointerException("fileFilter");
        }
        this.m_aFileFilter = aFileFilter;
    }

    @Override
    public boolean matchesFilter(@Nullable File aFile) {
        return this.m_aFileFilter.accept(aFile);
    }

    public String toString() {
        return new ToStringGenerator(this).append("fileFilter", this.m_aFileFilter).toString();
    }

    @Nonnull
    public static IFilter<File> getANDChained(FileFilter ... aFileFilters) {
        if (ArrayHelper.isEmpty(aFileFilters)) {
            throw new IllegalArgumentException("fileFilters");
        }
        ArrayList<FileFilterToIFilterAdapter> aFilters = new ArrayList<FileFilterToIFilterAdapter>();
        for (FileFilter aFileFilter : aFileFilters) {
            aFilters.add(new FileFilterToIFilterAdapter(aFileFilter));
        }
        return new FilterChainAND<File>(aFilters);
    }

    @Nonnull
    public static IFilter<File> getANDChained(FilenameFilter ... aFilenameFilters) {
        if (ArrayHelper.isEmpty(aFilenameFilters)) {
            throw new IllegalArgumentException("filenameFilters");
        }
        ArrayList<FileFilterToIFilterAdapter> aFilters = new ArrayList<FileFilterToIFilterAdapter>();
        for (FilenameFilter aFilenameFilter : aFilenameFilters) {
            aFilters.add(new FileFilterToIFilterAdapter(aFilenameFilter));
        }
        return new FilterChainAND<File>(aFilters);
    }

    @Nonnull
    public static IFilter<File> getORChained(FileFilter ... aFileFilters) {
        if (ArrayHelper.isEmpty(aFileFilters)) {
            throw new IllegalArgumentException("fileFilters");
        }
        ArrayList<FileFilterToIFilterAdapter> aFilters = new ArrayList<FileFilterToIFilterAdapter>();
        for (FileFilter aFileFilter : aFileFilters) {
            aFilters.add(new FileFilterToIFilterAdapter(aFileFilter));
        }
        return new FilterChainOR<File>(aFilters);
    }

    @Nonnull
    public static IFilter<File> getORChained(FilenameFilter ... aFilenameFilters) {
        if (ArrayHelper.isEmpty(aFilenameFilters)) {
            throw new IllegalArgumentException("fileFilters");
        }
        ArrayList<FileFilterToIFilterAdapter> aFilters = new ArrayList<FileFilterToIFilterAdapter>();
        for (FilenameFilter aFilenameFilter : aFilenameFilters) {
            aFilters.add(new FileFilterToIFilterAdapter(aFilenameFilter));
        }
        return new FilterChainOR<File>(aFilters);
    }
}

