/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.io.file;

import com.phloc.commons.annotations.Nonempty;
import com.phloc.commons.equals.EqualsUtils;
import com.phloc.commons.string.StringHelper;
import com.phloc.commons.system.SystemHelper;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public final class FilenameHelper {
    public static final char EXTENSION_SEPARATOR = '.';
    public static final char ILLEGAL_FILENAME_CHAR_REPLACEMENT = '_';
    public static final String PATH_CURRENT = ".";
    public static final String PATH_PARENT = "..";
    public static final char UNIX_SEPARATOR = '/';
    public static final String UNIX_SEPARATOR_STR = Character.toString('/');
    public static final char WINDOWS_SEPARATOR = '\\';
    private static final Logger s_aLogger = LoggerFactory.getLogger(FilenameHelper.class);
    private static final char[] ILLEGAL_CHARACTERS = new char[]{'\u0000', '<', '>', '?', '*', ':', '|', '\"'};
    private static final String[] ILLEGAL_PREFIXES = new String[]{"CLOCK$", "CON", "PRN", "AUX", "NUL", "COM2", "COM3", "COM4", "COM5", "COM6", "COM7", "COM8", "COM9", "LPT1", "LPT2", "LPT3", "LPT4", "LPT5", "LPT6", "LPT7", "LPT8", "LPT9"};
    private static final char[] ILLEGAL_SUFFIXES = new char[]{'.', ' ', '\t'};
    private static final FilenameHelper s_aInstance = new FilenameHelper();

    private FilenameHelper() {
    }

    public static int getIndexOfExtension(@Nullable String sFilename) {
        if (sFilename == null) {
            return -1;
        }
        int nExtensionIndex = sFilename.lastIndexOf(46);
        int nLastSepIndex = FilenameHelper.getIndexOfLastSeparator(sFilename);
        return nLastSepIndex > nExtensionIndex ? -1 : nExtensionIndex;
    }

    @Nullable
    public static String getWithoutExtension(@Nullable File aFile) {
        return aFile == null ? null : FilenameHelper.getWithoutExtension(aFile.getPath());
    }

    @Nullable
    public static String getWithoutExtension(@Nullable String sFilename) {
        int nIndex = FilenameHelper.getIndexOfExtension(sFilename);
        return nIndex == -1 ? sFilename : sFilename.substring(0, nIndex);
    }

    @Nonnull
    public static String getExtension(@Nullable File aFile) {
        return aFile == null ? "" : FilenameHelper.getExtension(aFile.getName());
    }

    @Nonnull
    public static String getExtension(@Nullable String sFilename) {
        int nIndex = FilenameHelper.getIndexOfExtension(sFilename);
        if (nIndex == -1) {
            return "";
        }
        return sFilename.substring(nIndex + 1);
    }

    public static boolean hasExtension(@Nullable File aFile, String ... aExtensions) {
        if (aExtensions == null) {
            throw new NullPointerException("extensions");
        }
        String sExt = FilenameHelper.getExtension(aFile);
        for (String sExtension : aExtensions) {
            if (!sExt.equalsIgnoreCase(sExtension)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasExtension(@Nullable String sFilename, String ... aExtensions) {
        if (aExtensions == null) {
            throw new NullPointerException("extensions");
        }
        String sExt = FilenameHelper.getExtension(sFilename);
        for (String sExtension : aExtensions) {
            if (!sExt.equalsIgnoreCase(sExtension)) continue;
            return true;
        }
        return false;
    }

    public static int getIndexOfLastSeparator(@Nullable String sFilename) {
        return sFilename == null ? -1 : Math.max(sFilename.lastIndexOf(47), sFilename.lastIndexOf(92));
    }

    @Nullable
    public static String getWithoutPath(@Nullable File aFile) {
        return aFile == null ? null : aFile.getName();
    }

    @Nullable
    public static String getWithoutPath(@Nullable String sAbsoluteFilename) {
        if (sAbsoluteFilename == null) {
            return null;
        }
        int nLastSepIndex = FilenameHelper.getIndexOfLastSeparator(sAbsoluteFilename);
        return nLastSepIndex == -1 ? sAbsoluteFilename : sAbsoluteFilename.substring(nLastSepIndex + 1);
    }

    @Nullable
    public static String getPath(@Nullable String sAbsoluteFilename) {
        if (sAbsoluteFilename == null) {
            return null;
        }
        int nLastSepIndex = FilenameHelper.getIndexOfLastSeparator(sAbsoluteFilename);
        return nLastSepIndex == -1 ? "" : sAbsoluteFilename.substring(0, nLastSepIndex + 1);
    }

    @Nullable
    public static String getBaseName(@Nullable File aFile) {
        return aFile == null ? null : FilenameHelper.getWithoutExtension(aFile.getName());
    }

    @Nullable
    public static String getBaseName(@Nullable String sAbsoluteFilename) {
        return FilenameHelper.getWithoutExtension(FilenameHelper.getWithoutPath(sAbsoluteFilename));
    }

    @Nullable
    public static String getPathUsingUnixSeparator(@Nullable File aFile) {
        return aFile == null ? null : FilenameHelper.getPathUsingUnixSeparator(aFile.getPath());
    }

    @Nullable
    public static String getPathUsingUnixSeparator(@Nullable String sAbsoluteFilename) {
        return sAbsoluteFilename == null ? null : sAbsoluteFilename.replace('\\', '/');
    }

    public static boolean isEqualIgnoreFileSeparator(@Nullable String sAbsoluteFilename1, @Nullable String sAbsoluteFilename2) {
        return EqualsUtils.equals(FilenameHelper.getPathUsingUnixSeparator(sAbsoluteFilename1), FilenameHelper.getPathUsingUnixSeparator(sAbsoluteFilename2));
    }

    @Nullable
    public static String getSecureFilename(@Nullable String sFilename) {
        if (sFilename == null) {
            return null;
        }
        int nIdx0 = sFilename.indexOf(0);
        return nIdx0 == -1 ? sFilename : sFilename.substring(0, nIdx0);
    }

    public static boolean isValidFilename(@Nullable String sFilename) {
        if (StringHelper.hasNoText(sFilename)) {
            return false;
        }
        if (FilenameHelper.containsPathSeparatorChar(sFilename)) {
            return false;
        }
        if (StringHelper.endsWithAny(sFilename, ILLEGAL_SUFFIXES)) {
            return false;
        }
        for (char cIllegal : ILLEGAL_CHARACTERS) {
            if (sFilename.indexOf(cIllegal) == -1) continue;
            return false;
        }
        for (String sIllegalPrefix : ILLEGAL_PREFIXES) {
            if (!sFilename.equalsIgnoreCase(sIllegalPrefix)) continue;
            return false;
        }
        String string = sFilename.toUpperCase(SystemHelper.getSystemLocale());
        for (String sIllegalPrefix : ILLEGAL_PREFIXES) {
            if (!string.startsWith(sIllegalPrefix + PATH_CURRENT)) continue;
            return false;
        }
        return true;
    }

    public static boolean isValidFilenameWithPaths(@Nullable String sFilename) {
        if (StringHelper.hasNoText(sFilename)) {
            return false;
        }
        File aFile = new File(sFilename);
        while (aFile != null) {
            String sCurFilename = aFile.getName();
            File aParentFile = aFile.getParentFile();
            if (sCurFilename.length() == 0 && aParentFile == null) break;
            if (!FilenameHelper.isValidFilename(sCurFilename)) {
                return false;
            }
            aFile = aParentFile;
        }
        return true;
    }

    @Nullable
    @Nonempty
    public static String getAsSecureValidFilename(@Nullable String sFilename) {
        String ret = FilenameHelper.getSecureFilename(sFilename);
        if (StringHelper.hasText(ret)) {
            while (ret.length() > 0 && StringHelper.endsWithAny(ret, ILLEGAL_SUFFIXES)) {
                ret = ret.substring(0, ret.length() - 1);
            }
            for (char cIllegal : ILLEGAL_CHARACTERS) {
                ret = ret.replace(cIllegal, '_');
            }
            for (String sIllegalPrefix : ILLEGAL_PREFIXES) {
                if (!ret.equalsIgnoreCase(sIllegalPrefix)) continue;
                ret = '_' + ret;
                break;
            }
            String string = ret.toUpperCase(SystemHelper.getSystemLocale());
            for (String sIllegalPrefix : ILLEGAL_PREFIXES) {
                if (!string.startsWith(sIllegalPrefix + PATH_CURRENT)) continue;
                ret = '_' + ret;
                break;
            }
        }
        return StringHelper.hasNoText(ret) ? null : ret;
    }

    @Nullable
    @Nonempty
    public static String getAsSecureValidASCIIFilename(@Nullable String sFilename) {
        String sValid = FilenameHelper.getAsSecureValidFilename(sFilename);
        if (sValid == null) {
            return null;
        }
        StringBuilder ret = new StringBuilder(sValid.length());
        for (char c : sValid.toCharArray()) {
            if (c >= ' ' && c < '\u0080') {
                ret.append(c);
                continue;
            }
            ret.append('_');
        }
        return ret.toString();
    }

    public static boolean isPathSeparatorChar(char c) {
        return c == '/' || c == '\\';
    }

    public static boolean startsWithPathSeparatorChar(@Nullable CharSequence s) {
        return FilenameHelper.isPathSeparatorChar(StringHelper.getFirstChar(s));
    }

    public static boolean endsWithPathSeparatorChar(@Nullable CharSequence s) {
        return FilenameHelper.isPathSeparatorChar(StringHelper.getLastChar(s));
    }

    public static boolean containsPathSeparatorChar(@Nullable String s) {
        return s != null && (s.indexOf(47) >= 0 || s.indexOf(92) >= 0);
    }

    public static boolean isSystemInternalDirectory(@Nullable File aFile) {
        return aFile != null && FilenameHelper.isSystemInternalDirectory(aFile.getName());
    }

    public static boolean isSystemInternalDirectory(@Nullable CharSequence s) {
        return s != null && (s.equals(PATH_CURRENT) || s.equals(PATH_PARENT));
    }

    @Nonnull
    public static String getCleanPath(@Nonnull File aFile) {
        try {
            return FilenameHelper.getPathUsingUnixSeparator(aFile.getCanonicalPath());
        }
        catch (IOException ex) {
            s_aLogger.warn("Using getCleanPath on an invalid file '" + aFile + "'", (Throwable)ex);
            return FilenameHelper.getCleanPath(aFile.getAbsolutePath());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public static String getCleanPath(@Nullable String sPath) {
        int i;
        int nPrefixIndex;
        if (sPath == null) {
            return null;
        }
        String sPathToUse = FilenameHelper.getSecureFilename(sPath);
        sPathToUse = FilenameHelper.getPathUsingUnixSeparator(sPathToUse);
        String sPrefix = "";
        int nProtoIdx = sPathToUse.indexOf("://");
        if (nProtoIdx > -1) {
            nPrefixIndex = sPathToUse.indexOf(47, nProtoIdx + 3);
            if (nPrefixIndex < 0) return sPathToUse;
            sPrefix = sPathToUse.substring(0, nPrefixIndex + 1);
            sPathToUse = sPathToUse.substring(nPrefixIndex + 1);
        } else {
            nPrefixIndex = sPathToUse.indexOf(58);
            if (nPrefixIndex >= 0) {
                sPrefix = sPathToUse.substring(0, nPrefixIndex + 1);
                sPathToUse = sPathToUse.substring(nPrefixIndex + 1);
            }
        }
        if (StringHelper.startsWith((CharSequence)sPathToUse, '/')) {
            sPrefix = sPrefix + '/';
            sPathToUse = sPathToUse.substring(1);
        }
        ArrayList<String> aElements = new ArrayList<String>();
        int nParentFolders = 0;
        String[] aPathArray = StringHelper.getExplodedArray('/', sPathToUse);
        for (i = aPathArray.length - 1; i >= 0; --i) {
            String sElement = aPathArray[i];
            if (sElement.length() == 0 || PATH_CURRENT.equals(sElement)) continue;
            if (PATH_PARENT.equals(sElement)) {
                ++nParentFolders;
                continue;
            }
            if (nParentFolders > 0) {
                --nParentFolders;
                continue;
            }
            aElements.add(0, sElement);
        }
        for (i = 0; i < nParentFolders; ++i) {
            aElements.add(0, PATH_PARENT);
        }
        return sPrefix + StringHelper.getImploded(UNIX_SEPARATOR_STR, aElements);
    }

    @Nonnull
    public static String getCleanConcatenatedUrlPath(@Nonnull String sURL, @Nonnull String sPath) {
        if (sURL == null) {
            throw new NullPointerException("url");
        }
        if (sPath == null) {
            throw new NullPointerException("path");
        }
        if (StringHelper.hasNoText(sPath)) {
            return FilenameHelper.getCleanPath(sURL);
        }
        String sRealURL = StringHelper.endsWith((CharSequence)sURL, '/') ? sURL : sURL + '/';
        String sRealPath = StringHelper.startsWith((CharSequence)sPath, '/') ? sPath.substring(1) : sPath;
        return FilenameHelper.getCleanPath(sRealURL + sRealPath);
    }

    @Nullable
    @CheckReturnValue
    public static String ensurePathStartingWithSeparator(@Nullable String sPath) {
        return sPath == null ? null : (FilenameHelper.startsWithPathSeparatorChar(sPath) ? sPath : File.separator + sPath);
    }

    @Nullable
    @CheckReturnValue
    public static String ensurePathEndingWithoutSeparator(@Nullable String sPath) {
        if (sPath == null) {
            return null;
        }
        String sRet = sPath;
        while (FilenameHelper.endsWithPathSeparatorChar(sRet)) {
            sRet = sRet.substring(0, sRet.length() - 1);
        }
        return sRet;
    }

    @Nullable
    @CheckReturnValue
    public static String ensurePathEndingWithSeparator(@Nullable String sPath) {
        return sPath == null ? null : (FilenameHelper.endsWithPathSeparatorChar(sPath) ? sPath : sPath + File.separator);
    }

    @Nullable
    public static String getRelativeToParentDirectory(@Nonnull File aFile, @Nullable File aParentDirectory) {
        if (aFile == null) {
            throw new NullPointerException("file");
        }
        String sCleanedFile = FilenameHelper.getCleanPath(aFile);
        if (aParentDirectory == null) {
            return sCleanedFile;
        }
        String sRelative = StringHelper.trimStart(sCleanedFile, FilenameHelper.getCleanPath(aParentDirectory));
        if (sRelative.equals(sCleanedFile)) {
            return null;
        }
        if (FilenameHelper.startsWithPathSeparatorChar(sRelative)) {
            sRelative = sRelative.substring(1);
        }
        return sRelative;
    }

    @Nullable
    public static String getAbsoluteWithEnsuredParentDirectory(@Nonnull File aParentDirectory, @Nonnull String sFilePath) {
        if (aParentDirectory == null) {
            throw new NullPointerException("parentDirectory");
        }
        if (sFilePath == null) {
            throw new NullPointerException("filePath");
        }
        String sCleanParentPath = FilenameHelper.getCleanPath(aParentDirectory);
        String sEstimatedPath = FilenameHelper.getCleanPath(new File(sCleanParentPath, sFilePath));
        if (!sEstimatedPath.startsWith(sCleanParentPath)) {
            return null;
        }
        return sEstimatedPath;
    }
}

