/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.equals;

import com.phloc.commons.annotations.UseDirectEqualsAndHashCode;
import com.phloc.commons.equals.IEqualsImplementation;
import com.phloc.commons.equals.IEqualsImplementationRegistrarSPI;
import com.phloc.commons.equals.IEqualsImplementationRegistry;
import com.phloc.commons.lang.ClassHelper;
import com.phloc.commons.lang.ClassHierarchyCache;
import com.phloc.commons.lang.ServiceLoaderBackport;
import com.phloc.commons.state.EChange;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class EqualsImplementationRegistry
implements IEqualsImplementationRegistry {
    private static final Logger s_aLogger = LoggerFactory.getLogger(EqualsImplementationRegistry.class);
    private static final EqualsImplementationRegistry s_aInstance = new EqualsImplementationRegistry();
    private final ReadWriteLock m_aRWLock = new ReentrantReadWriteLock();
    private final Map<Class<?>, IEqualsImplementation> m_aMap = new WeakHashMap();
    private final Map<String, Boolean> m_aDirectEquals = new HashMap<String, Boolean>();
    private final Map<String, Boolean> m_aImplementsEquals = new HashMap<String, Boolean>();

    private EqualsImplementationRegistry() {
        for (IEqualsImplementationRegistrarSPI aRegistrar : ServiceLoaderBackport.load(IEqualsImplementationRegistrarSPI.class)) {
            aRegistrar.registerEqualsImplementations(this);
        }
    }

    @Nonnull
    public static EqualsImplementationRegistry getInstance() {
        return s_aInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerEqualsImplementation(@Nonnull Class<?> aClass, @Nonnull IEqualsImplementation aImpl) {
        if (aClass == null) {
            throw new NullPointerException("class");
        }
        if (aImpl == null) {
            throw new NullPointerException("implementation");
        }
        if (aClass.equals(Object.class)) {
            throw new IllegalArgumentException("You cannot provide an equals implementation for Object.class!");
        }
        this.m_aRWLock.writeLock().lock();
        try {
            if (this.m_aMap.containsKey(aClass)) {
                s_aLogger.warn("Another equals implementation for class " + aClass + " is already implemented!");
            } else {
                this.m_aMap.put(aClass, aImpl);
            }
        }
        finally {
            this.m_aRWLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public EChange unregisterEqualsImplementation(@Nonnull Class<?> aClass) {
        this.m_aRWLock.writeLock().lock();
        try {
            EChange eChange = EChange.valueOf(this.m_aMap.remove(aClass) != null);
            return eChange;
        }
        finally {
            this.m_aRWLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean _isUseDirectEquals(@Nonnull Class<?> aClass) {
        Boolean aSavedState;
        String sClassName = aClass.getName();
        this.m_aRWLock.readLock().lock();
        try {
            aSavedState = this.m_aDirectEquals.get(sClassName);
            if (aSavedState != null) {
                boolean bl = aSavedState;
                return bl;
            }
        }
        finally {
            this.m_aRWLock.readLock().unlock();
        }
        this.m_aRWLock.writeLock().lock();
        try {
            aSavedState = this.m_aDirectEquals.get(sClassName);
            if (aSavedState != null) {
                boolean bl = aSavedState;
                return bl;
            }
            boolean bHasAnnotation = aClass.getAnnotation(UseDirectEqualsAndHashCode.class) != null;
            this.m_aDirectEquals.put(sClassName, bHasAnnotation);
            boolean bl = bHasAnnotation;
            return bl;
        }
        finally {
            this.m_aRWLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean _implementsEqualsItself(@Nonnull Class<?> aClass) {
        Boolean aSavedState;
        String sClassName = aClass.getName();
        this.m_aRWLock.readLock().lock();
        try {
            aSavedState = this.m_aImplementsEquals.get(sClassName);
            if (aSavedState != null) {
                boolean bl = aSavedState;
                return bl;
            }
        }
        finally {
            this.m_aRWLock.readLock().unlock();
        }
        this.m_aRWLock.writeLock().lock();
        try {
            aSavedState = this.m_aImplementsEquals.get(sClassName);
            if (aSavedState != null) {
                boolean bl = aSavedState;
                return bl;
            }
            boolean bRet = false;
            try {
                Method aMethod = aClass.getDeclaredMethod("equals", Object.class);
                if (aMethod != null && aMethod.getReturnType().equals(Boolean.TYPE)) {
                    bRet = true;
                }
            }
            catch (NoSuchMethodException ex) {
                // empty catch block
            }
            this.m_aImplementsEquals.put(sClassName, bRet);
            boolean bl = bRet;
            return bl;
        }
        finally {
            this.m_aRWLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public IEqualsImplementation getBestMatchingEqualsImplementation(@Nullable Class<?> aClass) {
        if (aClass != null) {
            Class aMatchingClass;
            IEqualsImplementation aMatchingImplementation;
            block19: {
                aMatchingImplementation = null;
                aMatchingClass = null;
                if (this._isUseDirectEquals(aClass)) {
                    return null;
                }
                this.m_aRWLock.readLock().lock();
                try {
                    aMatchingImplementation = this.m_aMap.get(aClass);
                    if (aMatchingImplementation != null) {
                        aMatchingClass = aClass;
                        break block19;
                    }
                    for (WeakReference<Class<?>> aCurWRClass : ClassHierarchyCache.getClassHierarchyIterator(aClass)) {
                        IEqualsImplementation aImpl;
                        Class aCurClass = (Class)aCurWRClass.get();
                        if (aCurClass == null || (aImpl = this.m_aMap.get(aCurClass)) == null) continue;
                        aMatchingImplementation = aImpl;
                        aMatchingClass = aCurClass;
                        if (s_aLogger.isDebugEnabled()) {
                            s_aLogger.debug("Found hierarchical match with class " + aMatchingClass + " when searching for " + aClass);
                        }
                        break;
                    }
                }
                finally {
                    this.m_aRWLock.readLock().unlock();
                }
            }
            if (aMatchingImplementation != null) {
                if (ClassHelper.isInterface(aMatchingClass) && this._implementsEqualsItself(aClass)) {
                    this.m_aRWLock.writeLock().lock();
                    try {
                        this.m_aDirectEquals.put(aClass.getName(), Boolean.TRUE);
                    }
                    finally {
                        this.m_aRWLock.writeLock().unlock();
                    }
                    return null;
                }
                if (!aMatchingClass.equals(aClass)) {
                    this.registerEqualsImplementation(aClass, aMatchingImplementation);
                }
                return aMatchingImplementation;
            }
            if (ClassHelper.isArrayClass(aClass)) {
                return new ArrayEqualsImplementation();
            }
            this.m_aRWLock.writeLock().lock();
            try {
                this.m_aDirectEquals.put(aClass.getName(), Boolean.TRUE);
            }
            finally {
                this.m_aRWLock.writeLock().unlock();
            }
        }
        if (s_aLogger.isDebugEnabled()) {
            s_aLogger.debug("Found no equals implementation for " + aClass);
        }
        return null;
    }

    public static <T> boolean areEqual(@Nullable T aObj1, @Nullable T aObj2) {
        Class<?> aClass2;
        if (aObj1 == aObj2) {
            return true;
        }
        if (aObj1 == null || aObj2 == null) {
            return false;
        }
        Class<?> aClass1 = aObj1.getClass();
        if (!aClass1.equals(aClass2 = aObj2.getClass())) {
            return false;
        }
        IEqualsImplementation aImpl = s_aInstance.getBestMatchingEqualsImplementation(aClass1);
        boolean bAreEqual = aImpl == null ? aObj1.equals(aObj2) : aImpl.areEqual(aObj1, aObj2);
        return bAreEqual;
    }

    private static final class ArrayEqualsImplementation
    implements IEqualsImplementation {
        @Override
        public boolean areEqual(Object aObj1, Object aObj2) {
            Object[] aArray1 = (Object[])aObj1;
            int nLength = aArray1.length;
            Object[] aArray2 = (Object[])aObj2;
            if (nLength != aArray2.length) {
                return false;
            }
            for (int i = 0; i < nLength; ++i) {
                if (EqualsImplementationRegistry.areEqual(aArray1[i], aArray2[i])) continue;
                return false;
            }
            return true;
        }
    }
}

