/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.equals;

import com.phloc.commons.annotations.IsSPIImplementation;
import com.phloc.commons.equals.EqualsImplementationRegistry;
import com.phloc.commons.equals.IEqualsImplementation;
import com.phloc.commons.equals.IEqualsImplementationRegistrarSPI;
import com.phloc.commons.equals.IEqualsImplementationRegistry;
import java.math.BigDecimal;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nonnull;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@IsSPIImplementation
public final class DefaultEqualsImplementationRegistrarSPI
implements IEqualsImplementationRegistrarSPI {
    @Override
    public void registerEqualsImplementations(@Nonnull IEqualsImplementationRegistry aRegistry) {
        aRegistry.registerEqualsImplementation(BigDecimal.class, new IEqualsImplementation(){

            @Override
            public boolean areEqual(Object aObj1, Object aObj2) {
                BigDecimal aRealObj1 = (BigDecimal)aObj1;
                BigDecimal aRealObj2 = (BigDecimal)aObj2;
                int nMaxScale = Math.max(aRealObj1.scale(), aRealObj2.scale());
                return aRealObj1.setScale(nMaxScale).equals(aRealObj2.setScale(nMaxScale));
            }
        });
        aRegistry.registerEqualsImplementation(Double.class, new IEqualsImplementation(){

            @Override
            public boolean areEqual(Object aObj1, Object aObj2) {
                Double aRealObj1 = (Double)aObj1;
                Double aRealObj2 = (Double)aObj2;
                return aRealObj1.compareTo(aRealObj2) == 0;
            }
        });
        aRegistry.registerEqualsImplementation(Float.class, new IEqualsImplementation(){

            @Override
            public boolean areEqual(Object aObj1, Object aObj2) {
                Float aRealObj1 = (Float)aObj1;
                Float aRealObj2 = (Float)aObj2;
                return aRealObj1.compareTo(aRealObj2) == 0;
            }
        });
        aRegistry.registerEqualsImplementation(StringBuffer.class, new IEqualsImplementation(){

            @Override
            public boolean areEqual(Object aObj1, Object aObj2) {
                return aObj1.toString().equals(aObj2.toString());
            }
        });
        aRegistry.registerEqualsImplementation(StringBuilder.class, new IEqualsImplementation(){

            @Override
            public boolean areEqual(Object aObj1, Object aObj2) {
                return aObj1.toString().equals(aObj2.toString());
            }
        });
        aRegistry.registerEqualsImplementation(Node.class, new IEqualsImplementation(){

            @Override
            public boolean areEqual(Object aObj1, Object aObj2) {
                Node aRealObj1 = (Node)aObj1;
                Node aRealObj2 = (Node)aObj2;
                if (aRealObj1.getNodeType() != aRealObj2.getNodeType()) {
                    return false;
                }
                if (!EqualsImplementationRegistry.areEqual(aRealObj1.getNodeName(), aRealObj2.getNodeName())) {
                    return false;
                }
                if (!EqualsImplementationRegistry.areEqual(aRealObj1.getLocalName(), aRealObj2.getLocalName())) {
                    return false;
                }
                if (!EqualsImplementationRegistry.areEqual(aRealObj1.getNamespaceURI(), aRealObj2.getNamespaceURI())) {
                    return false;
                }
                if (!EqualsImplementationRegistry.areEqual(aRealObj1.getPrefix(), aRealObj2.getPrefix())) {
                    return false;
                }
                if (!EqualsImplementationRegistry.areEqual(aRealObj1.getNodeValue(), aRealObj2.getNodeValue())) {
                    return false;
                }
                NodeList aNL1 = aRealObj1.getChildNodes();
                NodeList aNL2 = aRealObj2.getChildNodes();
                int nLength = aNL1.getLength();
                if (nLength != aNL2.getLength()) {
                    return false;
                }
                for (int i = 0; i < nLength; ++i) {
                    Node aChild2;
                    Node aChild1 = aNL1.item(i);
                    if (EqualsImplementationRegistry.areEqual(aChild1, aChild2 = aNL2.item(i))) continue;
                    return false;
                }
                return true;
            }
        });
        aRegistry.registerEqualsImplementation(URL.class, new IEqualsImplementation(){

            @Override
            public boolean areEqual(Object aObj1, Object aObj2) {
                URL aRealObj1 = (URL)aObj1;
                URL aRealObj2 = (URL)aObj2;
                return aRealObj1.toExternalForm().equals(aRealObj2.toExternalForm());
            }
        });
        aRegistry.registerEqualsImplementation(AtomicBoolean.class, new IEqualsImplementation(){

            @Override
            public boolean areEqual(Object aObj1, Object aObj2) {
                AtomicBoolean aRealObj1 = (AtomicBoolean)aObj1;
                AtomicBoolean aRealObj2 = (AtomicBoolean)aObj2;
                return aRealObj1.get() == aRealObj2.get();
            }
        });
        aRegistry.registerEqualsImplementation(AtomicInteger.class, new IEqualsImplementation(){

            @Override
            public boolean areEqual(Object aObj1, Object aObj2) {
                AtomicInteger aRealObj1 = (AtomicInteger)aObj1;
                AtomicInteger aRealObj2 = (AtomicInteger)aObj2;
                return aRealObj1.get() == aRealObj2.get();
            }
        });
        aRegistry.registerEqualsImplementation(AtomicLong.class, new IEqualsImplementation(){

            @Override
            public boolean areEqual(Object aObj1, Object aObj2) {
                AtomicLong aRealObj1 = (AtomicLong)aObj1;
                AtomicLong aRealObj2 = (AtomicLong)aObj2;
                return aRealObj1.get() == aRealObj2.get();
            }
        });
        aRegistry.registerEqualsImplementation(boolean[].class, new IEqualsImplementation(){

            @Override
            public boolean areEqual(Object aObj1, Object aObj2) {
                return Arrays.equals((boolean[])aObj1, (boolean[])aObj2);
            }
        });
        aRegistry.registerEqualsImplementation(byte[].class, new IEqualsImplementation(){

            @Override
            public boolean areEqual(Object aObj1, Object aObj2) {
                return Arrays.equals((byte[])aObj1, (byte[])aObj2);
            }
        });
        aRegistry.registerEqualsImplementation(char[].class, new IEqualsImplementation(){

            @Override
            public boolean areEqual(Object aObj1, Object aObj2) {
                return Arrays.equals((char[])aObj1, (char[])aObj2);
            }
        });
        aRegistry.registerEqualsImplementation(double[].class, new IEqualsImplementation(){

            @Override
            public boolean areEqual(Object aObj1, Object aObj2) {
                return Arrays.equals((double[])aObj1, (double[])aObj2);
            }
        });
        aRegistry.registerEqualsImplementation(float[].class, new IEqualsImplementation(){

            @Override
            public boolean areEqual(Object aObj1, Object aObj2) {
                return Arrays.equals((float[])aObj1, (float[])aObj2);
            }
        });
        aRegistry.registerEqualsImplementation(int[].class, new IEqualsImplementation(){

            @Override
            public boolean areEqual(Object aObj1, Object aObj2) {
                return Arrays.equals((int[])aObj1, (int[])aObj2);
            }
        });
        aRegistry.registerEqualsImplementation(long[].class, new IEqualsImplementation(){

            @Override
            public boolean areEqual(Object aObj1, Object aObj2) {
                return Arrays.equals((long[])aObj1, (long[])aObj2);
            }
        });
        aRegistry.registerEqualsImplementation(short[].class, new IEqualsImplementation(){

            @Override
            public boolean areEqual(Object aObj1, Object aObj2) {
                return Arrays.equals((short[])aObj1, (short[])aObj2);
            }
        });
        aRegistry.registerEqualsImplementation(Map.class, new IEqualsImplementation(){

            @Override
            public boolean areEqual(Object aObj1, Object aObj2) {
                Map aRealObj1 = (Map)aObj1;
                Map aRealObj2 = (Map)aObj2;
                if (aRealObj1.size() != aRealObj2.size()) {
                    return false;
                }
                for (Map.Entry aEntry1 : aRealObj1.entrySet()) {
                    Object aValue2;
                    Object aKey1 = aEntry1.getKey();
                    Object aValue1 = aEntry1.getValue();
                    if (!(aValue1 == null ? aRealObj2.get(aKey1) != null || !aRealObj2.containsKey(aKey1) : !EqualsImplementationRegistry.areEqual(aValue1, aValue2 = aRealObj2.get(aKey1)))) continue;
                    return false;
                }
                return true;
            }
        });
        aRegistry.registerEqualsImplementation(Collection.class, new IEqualsImplementation(){

            @Override
            public boolean areEqual(Object aObj1, Object aObj2) {
                Collection aRealObj1 = (Collection)aObj1;
                Collection aRealObj2 = (Collection)aObj2;
                if (aRealObj1.size() != aRealObj2.size()) {
                    return false;
                }
                Object[] aData1 = aRealObj1.toArray();
                Object[] aData2 = aRealObj2.toArray();
                return EqualsImplementationRegistry.areEqual(aData1, aData2);
            }
        });
        aRegistry.registerEqualsImplementation(Iterator.class, new IEqualsImplementation(){

            @Override
            public boolean areEqual(Object aObj1, Object aObj2) {
                Iterator aRealObj1 = (Iterator)aObj1;
                Iterator aRealObj2 = (Iterator)aObj2;
                while (aRealObj1.hasNext()) {
                    Object aChild2;
                    if (!aRealObj2.hasNext()) {
                        return false;
                    }
                    Object aChild1 = aRealObj1.next();
                    if (EqualsImplementationRegistry.areEqual(aChild1, aChild2 = aRealObj2.next())) continue;
                    return false;
                }
                return !aRealObj2.hasNext();
            }
        });
        aRegistry.registerEqualsImplementation(Enumeration.class, new IEqualsImplementation(){

            @Override
            public boolean areEqual(Object aObj1, Object aObj2) {
                Enumeration aRealObj1 = (Enumeration)aObj1;
                Enumeration aRealObj2 = (Enumeration)aObj2;
                while (aRealObj1.hasMoreElements()) {
                    Object aChild2;
                    if (!aRealObj2.hasMoreElements()) {
                        return false;
                    }
                    Object aChild1 = aRealObj1.nextElement();
                    if (EqualsImplementationRegistry.areEqual(aChild1, aChild2 = aRealObj2.nextElement())) continue;
                    return false;
                }
                return !aRealObj2.hasMoreElements();
            }
        });
    }
}

