/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.compare;

import com.phloc.commons.compare.ISortOrderIndicator;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public enum ESortOrder implements ISortOrderIndicator
{
    ASCENDING(1),
    DESCENDING(0);

    public static final ESortOrder DEFAULT;
    private final int m_nValue;

    private ESortOrder(int nValue) {
        this.m_nValue = nValue;
    }

    @Nonnegative
    public int getValue() {
        return this.m_nValue;
    }

    @Nonnull
    public String getValueAsString() {
        return Integer.toString(this.m_nValue);
    }

    @Override
    public boolean isAscending() {
        return this == ASCENDING;
    }

    @Override
    public boolean isDescending() {
        return this == DESCENDING;
    }

    @Nonnull
    public ESortOrder getAlternate() {
        return this.isAscending() ? DESCENDING : ASCENDING;
    }

    @Nonnull
    public static ESortOrder getFromValueOrDefault(int nValue) {
        return ESortOrder.getFromValue(nValue, DEFAULT);
    }

    @Nullable
    public static ESortOrder getFromValue(int nValue, @Nullable ESortOrder eDefault) {
        if (nValue == ESortOrder.ASCENDING.m_nValue) {
            return ASCENDING;
        }
        if (nValue == ESortOrder.DESCENDING.m_nValue) {
            return DESCENDING;
        }
        return eDefault;
    }

    static {
        DEFAULT = ASCENDING;
    }
}

