/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.combine;

import com.phloc.commons.annotations.Nonempty;
import com.phloc.commons.combine.ICombinator;
import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.string.StringHelper;
import com.phloc.commons.string.ToStringGenerator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class CombinatorStringWithSeparatorIgnoreNull
implements ICombinator<String> {
    private final String m_sSep;

    public CombinatorStringWithSeparatorIgnoreNull(@Nonnull @Nonempty String sSep) {
        if (StringHelper.hasNoText(sSep)) {
            throw new IllegalArgumentException("separator is null");
        }
        this.m_sSep = sSep;
    }

    @Override
    @Nullable
    public String combine(@Nullable String sFirst, @Nullable String sSecond) {
        if (sFirst == null) {
            return sSecond;
        }
        if (sSecond == null) {
            return sFirst;
        }
        return sFirst + this.m_sSep + sSecond;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CombinatorStringWithSeparatorIgnoreNull)) {
            return false;
        }
        CombinatorStringWithSeparatorIgnoreNull rhs = (CombinatorStringWithSeparatorIgnoreNull)o;
        return this.m_sSep.equals(rhs.m_sSep);
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_sSep).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("sep", this.m_sSep).toString();
    }
}

