/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.collections.triple;

import com.phloc.commons.collections.triple.IReadonlyTriple;
import com.phloc.commons.collections.triple.ITriple;
import com.phloc.commons.equals.EqualsUtils;
import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.state.EChange;
import com.phloc.commons.string.ToStringGenerator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class Triple<DATA1TYPE, DATA2TYPE, DATA3TYPE>
implements ITriple<DATA1TYPE, DATA2TYPE, DATA3TYPE> {
    private DATA1TYPE m_aFirst;
    private DATA2TYPE m_aSecond;
    private DATA3TYPE m_aThird;

    public <T2 extends DATA1TYPE, U2 extends DATA2TYPE, V2 extends DATA3TYPE> Triple(@Nullable T2 aFirst, @Nullable U2 aSecond, @Nullable V2 aThird) {
        this.m_aFirst = aFirst;
        this.m_aSecond = aSecond;
        this.m_aThird = aThird;
    }

    public Triple(@Nonnull IReadonlyTriple<? extends DATA1TYPE, ? extends DATA2TYPE, ? extends DATA3TYPE> rhs) {
        this.m_aFirst = rhs.getFirst();
        this.m_aSecond = rhs.getSecond();
        this.m_aThird = rhs.getThird();
    }

    @Override
    @Nullable
    public DATA1TYPE getFirst() {
        return this.m_aFirst;
    }

    @Override
    @Nonnull
    public EChange setFirst(@Nullable DATA1TYPE aFirst) {
        if (EqualsUtils.equals(aFirst, this.m_aFirst)) {
            return EChange.UNCHANGED;
        }
        this.m_aFirst = aFirst;
        return EChange.CHANGED;
    }

    @Override
    @Nullable
    public DATA2TYPE getSecond() {
        return this.m_aSecond;
    }

    @Override
    @Nonnull
    public EChange setSecond(@Nullable DATA2TYPE aSecond) {
        if (EqualsUtils.equals(aSecond, this.m_aSecond)) {
            return EChange.UNCHANGED;
        }
        this.m_aSecond = aSecond;
        return EChange.CHANGED;
    }

    @Override
    @Nullable
    public DATA3TYPE getThird() {
        return this.m_aThird;
    }

    @Override
    @Nonnull
    public EChange setThird(@Nullable DATA3TYPE aThird) {
        if (EqualsUtils.equals(aThird, this.m_aThird)) {
            return EChange.UNCHANGED;
        }
        this.m_aThird = aThird;
        return EChange.CHANGED;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Triple)) {
            return false;
        }
        Triple rhs = (Triple)o;
        return EqualsUtils.equals(this.m_aFirst, rhs.m_aFirst) && EqualsUtils.equals(this.m_aSecond, rhs.m_aSecond) && EqualsUtils.equals(this.m_aThird, rhs.m_aThird);
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_aFirst).append(this.m_aSecond).append(this.m_aThird).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(null).append("first", this.m_aFirst).append("second", this.m_aSecond).append("third", this.m_aThird).toString();
    }

    @Nonnull
    public static <T, U, V> ITriple<T, U, V> create(@Nullable T aFirst, @Nullable U aSecond, @Nullable V aThird) {
        return new Triple(aFirst, aSecond, aThird);
    }
}

