/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.collections.pair;

import com.phloc.commons.collections.pair.IPair;
import com.phloc.commons.collections.pair.IReadonlyPair;
import com.phloc.commons.equals.EqualsUtils;
import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.state.EChange;
import com.phloc.commons.string.ToStringGenerator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class Pair<DATA1TYPE, DATA2TYPE>
implements IPair<DATA1TYPE, DATA2TYPE> {
    private DATA1TYPE m_aFirst;
    private DATA2TYPE m_aSecond;

    public Pair() {
        this(null, null);
    }

    public <T2 extends DATA1TYPE, U2 extends DATA2TYPE> Pair(@Nullable T2 aFirst, @Nullable U2 aSecond) {
        this.m_aFirst = aFirst;
        this.m_aSecond = aSecond;
    }

    public Pair(@Nonnull IReadonlyPair<? extends DATA1TYPE, ? extends DATA2TYPE> rhs) {
        this.m_aFirst = rhs.getFirst();
        this.m_aSecond = rhs.getSecond();
    }

    @Override
    @Nullable
    public DATA1TYPE getFirst() {
        return this.m_aFirst;
    }

    @Override
    @Nonnull
    public EChange setFirst(@Nullable DATA1TYPE aFirst) {
        if (EqualsUtils.equals(aFirst, this.m_aFirst)) {
            return EChange.UNCHANGED;
        }
        this.m_aFirst = aFirst;
        return EChange.CHANGED;
    }

    @Override
    @Nullable
    public DATA2TYPE getSecond() {
        return this.m_aSecond;
    }

    @Override
    @Nonnull
    public EChange setSecond(@Nullable DATA2TYPE aSecond) {
        if (EqualsUtils.equals(aSecond, this.m_aSecond)) {
            return EChange.UNCHANGED;
        }
        this.m_aSecond = aSecond;
        return EChange.CHANGED;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Pair)) {
            return false;
        }
        Pair rhs = (Pair)o;
        return EqualsUtils.equals(this.m_aFirst, rhs.m_aFirst) && EqualsUtils.equals(this.m_aSecond, rhs.m_aSecond);
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_aFirst).append(this.m_aSecond).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(null).append("first", this.m_aFirst).append("second", this.m_aSecond).toString();
    }

    @Nonnull
    public static <T, U> IPair<T, U> create(@Nullable T aFirst, @Nullable U aSecond) {
        return new Pair(aFirst, aSecond);
    }
}

