/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.collections.list;

import com.phloc.commons.IHasSize;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public abstract class AbstractWrappedList<ELEMENTTYPE>
implements List<ELEMENTTYPE>,
IHasSize {
    private final List<ELEMENTTYPE> m_aSrc;

    public AbstractWrappedList(@Nonnull List<ELEMENTTYPE> aList) {
        if (aList == null) {
            throw new NullPointerException("list");
        }
        this.m_aSrc = aList;
    }

    @Override
    @Nullable
    public ELEMENTTYPE get(@Nonnegative int nIndex) {
        return this.m_aSrc.get(nIndex);
    }

    @Override
    public boolean add(@Nullable ELEMENTTYPE aElement) {
        return this.m_aSrc.add(aElement);
    }

    @Override
    public void add(@Nonnegative int nIndex, @Nullable ELEMENTTYPE aElement) {
        this.m_aSrc.add(nIndex, aElement);
    }

    @Override
    public boolean addAll(@Nonnull Collection<? extends ELEMENTTYPE> aElements) {
        return this.m_aSrc.addAll(aElements);
    }

    @Override
    public boolean addAll(@Nonnegative int nIndex, @Nonnull Collection<? extends ELEMENTTYPE> aElements) {
        return this.m_aSrc.addAll(nIndex, aElements);
    }

    @Override
    public void clear() {
        this.m_aSrc.clear();
    }

    @Override
    public boolean contains(Object aElement) {
        return this.m_aSrc.contains(aElement);
    }

    @Override
    public boolean containsAll(Collection<?> aElements) {
        return this.m_aSrc.containsAll(aElements);
    }

    @Override
    public int indexOf(Object aElement) {
        return this.m_aSrc.indexOf(aElement);
    }

    @Override
    public boolean isEmpty() {
        return this.m_aSrc.isEmpty();
    }

    @Override
    public Iterator<ELEMENTTYPE> iterator() {
        return this.m_aSrc.iterator();
    }

    @Override
    public int lastIndexOf(Object aElement) {
        return this.m_aSrc.lastIndexOf(aElement);
    }

    @Override
    public ListIterator<ELEMENTTYPE> listIterator() {
        return this.m_aSrc.listIterator();
    }

    @Override
    public ListIterator<ELEMENTTYPE> listIterator(int nIndex) {
        return this.m_aSrc.listIterator(nIndex);
    }

    @Override
    public boolean remove(Object aElement) {
        return this.m_aSrc.remove(aElement);
    }

    @Override
    public ELEMENTTYPE remove(int nIndex) {
        return this.m_aSrc.remove(nIndex);
    }

    @Override
    public boolean removeAll(Collection<?> aElements) {
        return this.m_aSrc.removeAll(aElements);
    }

    @Override
    public boolean retainAll(Collection<?> aElements) {
        return this.m_aSrc.retainAll(aElements);
    }

    @Override
    public ELEMENTTYPE set(@Nonnegative int nIndex, ELEMENTTYPE aElement) {
        return this.m_aSrc.set(nIndex, aElement);
    }

    @Override
    @Nonnegative
    public int size() {
        return this.m_aSrc.size();
    }

    @Override
    public List<ELEMENTTYPE> subList(int nFromIndex, int nToIndex) {
        return this.m_aSrc.subList(nFromIndex, nToIndex);
    }

    @Override
    public Object[] toArray() {
        return this.m_aSrc.toArray();
    }

    @Override
    public <ARRAYELEMENTTYPE> ARRAYELEMENTTYPE[] toArray(ARRAYELEMENTTYPE[] a) {
        return this.m_aSrc.toArray(a);
    }

    @Override
    public boolean equals(Object o) {
        return ((Object)this.m_aSrc).equals(o);
    }

    @Override
    public int hashCode() {
        return ((Object)this.m_aSrc).hashCode();
    }

    public String toString() {
        return this.m_aSrc.toString();
    }
}

