/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.collections.iterate;

import com.phloc.commons.collections.iterate.EmptyIterator;
import com.phloc.commons.string.ToStringGenerator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class CombinedIterator<ELEMENTTYPE>
implements Iterator<ELEMENTTYPE> {
    private final Iterator<? extends ELEMENTTYPE> m_aIter1;
    private final Iterator<? extends ELEMENTTYPE> m_aIter2;
    private boolean m_bFirstIter;

    public CombinedIterator(@Nullable Iterator<? extends ELEMENTTYPE> aIter1, @Nullable Iterator<? extends ELEMENTTYPE> aIter2) {
        this.m_aIter1 = aIter1;
        this.m_aIter2 = aIter2;
        this.m_bFirstIter = aIter1 != null;
    }

    @Override
    public boolean hasNext() {
        boolean ret = false;
        if (this.m_bFirstIter && !(ret = this.m_aIter1.hasNext())) {
            this.m_bFirstIter = false;
        }
        if (!this.m_bFirstIter) {
            ret = this.m_aIter2 != null && this.m_aIter2.hasNext();
        }
        return ret;
    }

    @Override
    @Nullable
    public ELEMENTTYPE next() {
        if (this.m_bFirstIter) {
            return this.m_aIter1.next();
        }
        if (this.m_aIter2 == null) {
            throw new NoSuchElementException();
        }
        return this.m_aIter2.next();
    }

    @Override
    public void remove() {
        if (this.m_bFirstIter) {
            this.m_aIter1.remove();
        } else {
            if (this.m_aIter2 == null) {
                throw new UnsupportedOperationException();
            }
            this.m_aIter2.remove();
        }
    }

    public String toString() {
        return new ToStringGenerator(this).append("iter1", this.m_aIter1).append("iter2", this.m_aIter2).toString();
    }

    @Nonnull
    public static <ELEMENTTYPE> Iterator<ELEMENTTYPE> create(@Nullable Iterator<? extends ELEMENTTYPE> aIter1, @Nullable Iterator<? extends ELEMENTTYPE> aIter2) {
        if (aIter1 == null && aIter2 == null) {
            return EmptyIterator.getInstance();
        }
        return new CombinedIterator<ELEMENTTYPE>(aIter1, aIter2);
    }
}

