/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.codec;

import com.phloc.commons.codec.AbstractLZWDictionary;
import com.phloc.commons.codec.LZWNode;
import com.phloc.commons.io.streams.NonBlockingByteArrayOutputStream;
import javax.annotation.Nullable;

final class LZWEncodeDictionary
extends AbstractLZWDictionary {
    private final LZWNode m_aRoot = new LZWNode();
    private final NonBlockingByteArrayOutputStream m_aByteBuf = new NonBlockingByteArrayOutputStream();

    @Override
    public void reset() {
        super.reset();
        for (int i = 0; i <= 255; ++i) {
            this.m_aRoot.setNode((byte)i, new LZWNode(i));
        }
        this.m_aByteBuf.reset();
    }

    public int getCodeLength() {
        return this.m_nCodeBits;
    }

    public void visit(byte nByteToVisit) {
        this.m_aByteBuf.write(nByteToVisit);
        LZWNode aCurNode = this.m_aRoot;
        for (byte aByte : this.m_aByteBuf.toByteArray()) {
            LZWNode aPrevNode = aCurNode;
            if ((aCurNode = aCurNode.getChildNode(aByte)) != null) continue;
            aPrevNode.setNode(aByte, new LZWNode(this.m_nFreeCode));
            this.addString(this.m_aByteBuf.toByteArray(), true);
            this.m_aByteBuf.reset();
            this.m_aByteBuf.write(nByteToVisit);
            break;
        }
    }

    @Nullable
    public LZWNode getNode(byte[] aBytes) {
        return this.m_aRoot.getNode(aBytes);
    }
}

