/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.www.http;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;

public class ByteRangeOutputStream
extends InputStream {
    int firstp = -1;
    int lastp = -1;
    InputStream in = null;

    public int read() throws IOException {
        if (this.firstp < this.lastp) {
            ++this.firstp;
            return this.in.read();
        }
        return -1;
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.firstp < this.lastp) {
            int n3 = Math.min(this.lastp - this.firstp, n2);
            n3 = this.in.read(byArray, n, n3);
            this.firstp += n3;
            return n3;
        }
        return -1;
    }

    public void close() throws IOException {
        this.in.close();
    }

    public int available() {
        return this.lastp - this.firstp;
    }

    public ByteRangeOutputStream(File file, int n, int n2) throws IOException {
        this.firstp = n;
        this.lastp = n2;
        RandomAccessFile randomAccessFile = new RandomAccessFile(file, "r");
        randomAccessFile.seek(n);
        this.in = new FileInputStream(randomAccessFile.getFD());
    }

    public ByteRangeOutputStream(InputStream inputStream, int n, int n2) throws IOException {
        this.firstp = n;
        this.lastp = n2;
        this.in = inputStream;
        inputStream.skip(n);
    }
}

