/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.util;

import org.w3c.util.ThreadCache;

class CachedThread
extends Thread {
    Runnable runner = null;
    boolean alive = true;
    ThreadCache cache = null;
    CachedThread next = null;
    CachedThread prev = null;
    boolean terminated = false;
    boolean started = false;
    boolean firstime = true;

    synchronized boolean isTerminated() {
        boolean bl = this.terminated;
        this.terminated = true;
        return bl;
    }

    synchronized Runnable waitForRunner() {
        boolean bl = false;
        while (this.alive) {
            if (this.runner != null) {
                Runnable runnable = this.runner;
                this.firstime = false;
                this.runner = null;
                return runnable;
            }
            if (this.firstime) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            this.alive = this.cache.isFree(this, bl);
            if (!this.alive) continue;
            try {
                int n = this.cache.getIdleTimeout();
                bl = false;
                if (n > 0) {
                    this.wait(n);
                    bl = this.runner == null;
                    continue;
                }
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        return null;
    }

    synchronized void kill() {
        this.alive = false;
        this.notify();
    }

    synchronized boolean wakeup(Runnable runnable) {
        if (this.alive) {
            this.runner = runnable;
            if (!this.started) {
                this.start();
            }
            this.notify();
            return true;
        }
        return false;
    }

    public synchronized void start() {
        super.start();
        this.started = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            do {
                Runnable runnable;
                if ((runnable = this.waitForRunner()) == null) continue;
                runnable.run();
            } while (this.alive);
        }
        finally {
            this.cache.isDead(this);
        }
    }

    CachedThread(ThreadCache threadCache, int n) {
        super(threadCache.getThreadGroup(), threadCache.getThreadGroup().getName() + ":" + n);
        this.cache = threadCache;
        this.setPriority(threadCache.getThreadPriority());
        this.setDaemon(true);
    }
}

