/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.tools.resources.serialization.xml;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;
import org.w3c.tools.resources.ArrayAttribute;
import org.w3c.tools.resources.AttributeHolder;
import org.w3c.tools.resources.Resource;
import org.w3c.tools.resources.ResourceFrame;
import org.w3c.tools.resources.SimpleAttribute;
import org.w3c.tools.resources.UnknownResource;
import org.w3c.tools.resources.serialization.SerializationException;
import org.w3c.tools.resources.serialization.xml.JigXML;
import org.xml.sax.AttributeList;
import org.xml.sax.HandlerBase;
import org.xml.sax.InputSource;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XMLReader
extends HandlerBase
implements JigXML {
    Parser parser = null;
    AttributeHolder[] holders = null;
    Reader reader = null;
    Stack resourceSetStack = null;
    Stack resourceStack = null;
    Stack defsStack = null;
    SimpleAttribute currentS = null;
    ArrayAttribute currentA = null;
    Stack faNameStack = null;
    int length = -1;
    boolean isavalue = false;
    String[] array = null;
    int arrayidx = -1;
    StringBuffer characters = null;
    String charvalue = null;

    public void startElement(String string, AttributeList attributeList) throws SAXException {
        this.endCharacters();
        String string2 = string.intern();
        if (string2 == JigXML.iRESOURCE_TAG) {
            Serializable serializable;
            String string3 = attributeList.getValue("class");
            try {
                serializable = Class.forName(string3);
                this.resourceStack.push(serializable.newInstance());
            }
            catch (Exception exception) {
                UnknownResource unknownResource = new UnknownResource();
                this.resourceStack.push(unknownResource);
            }
            serializable = new Hashtable(5);
            this.defsStack.push(serializable);
        } else if (string2 == JigXML.iATTRIBUTE_TAG) {
            String string4 = attributeList.getValue("class");
            try {
                Class<?> clazz = Class.forName(string4);
                this.currentS = (SimpleAttribute)clazz.newInstance();
                this.currentS.setName(attributeList.getValue("name"));
                this.currentS.setFlag(attributeList.getValue("flag"));
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.currentS = null;
            }
        } else if (string2 == JigXML.iARRAY_TAG) {
            String string5 = attributeList.getValue("class");
            try {
                Class<?> clazz = Class.forName(string5);
                this.currentA = (ArrayAttribute)clazz.newInstance();
                this.currentA.setName(attributeList.getValue("name"));
                this.currentA.setFlag(attributeList.getValue("flag"));
                this.length = Integer.parseInt(attributeList.getValue("length"));
                this.array = new String[this.length];
                this.arrayidx = 0;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.currentA = null;
            }
        } else if (string2 == JigXML.iRESARRAY_TAG) {
            this.resourceSetStack.push(new Vector(10));
            this.faNameStack.push(attributeList.getValue("name"));
        } else if (string2 == JigXML.iVALUE_TAG) {
            this.isavalue = true;
        }
    }

    public void endElement(String string) throws SAXException {
        this.endCharacters();
        String string2 = string.intern();
        if (string2 == JigXML.iRESOURCE_TAG) {
            AttributeHolder attributeHolder = (AttributeHolder)this.resourceStack.pop();
            attributeHolder.pickleValues((Hashtable)this.defsStack.pop());
            Vector vector = (Vector)this.resourceSetStack.peek();
            vector.addElement(attributeHolder);
        } else if (string2 == JigXML.iATTRIBUTE_TAG) {
            this.currentS = null;
        } else if (string2 == JigXML.iARRAY_TAG) {
            Hashtable hashtable = (Hashtable)this.defsStack.peek();
            Object object = this.currentA.unpickle(this.array);
            if (object != null) {
                hashtable.put(this.currentA.getName(), object);
            }
            this.currentA = null;
        } else if (string2 == JigXML.iRESARRAY_TAG) {
            Hashtable hashtable = (Hashtable)this.defsStack.peek();
            Vector vector = (Vector)this.resourceSetStack.pop();
            Object[] objectArray = new ResourceFrame[vector.size()];
            vector.copyInto(objectArray);
            hashtable.put((String)this.faNameStack.pop(), objectArray);
        } else if (string2 == JigXML.iVALUE_TAG) {
            this.isavalue = false;
        }
    }

    public void startDocument() throws SAXException {
        this.defsStack = new Stack();
        this.faNameStack = new Stack();
        this.resourceStack = new Stack();
        this.resourceSetStack = new Stack();
        this.resourceSetStack.push(new Vector(10));
    }

    public void endDocument() throws SAXException {
        Vector vector = (Vector)this.resourceSetStack.pop();
        this.holders = new AttributeHolder[vector.size()];
        vector.copyInto(this.holders);
        try {
            this.reader.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (this.charvalue == null) {
            this.charvalue = new String(cArray, n, n2);
        } else if (n2 > 0) {
            if (this.characters == null) {
                this.characters = new StringBuffer(this.charvalue);
            }
            this.characters.append(cArray, n, n2);
        }
    }

    private void endCharacters() {
        if (this.charvalue == null) {
            return;
        }
        String string = this.characters == null ? this.charvalue : this.characters.toString();
        this.characters = null;
        this.charvalue = null;
        if (this.currentS != null) {
            Hashtable hashtable = (Hashtable)this.defsStack.peek();
            if (!string.equals("@@NULL@@")) {
                hashtable.put(this.currentS.getName(), this.currentS.unpickle(string));
            }
        } else if (this.currentA != null && this.isavalue) {
            this.array[this.arrayidx++] = string;
        }
    }

    public void warning(SAXParseException sAXParseException) throws SAXException {
        System.out.println("WARNING in element " + sAXParseException.getPublicId());
        System.out.println("Sys  : " + sAXParseException.getSystemId());
        System.out.println("Line : " + sAXParseException.getLineNumber());
        System.out.println("Col  : " + sAXParseException.getColumnNumber());
        sAXParseException.printStackTrace();
    }

    public void error(SAXParseException sAXParseException) throws SAXException {
        System.out.println("ERROR in element " + sAXParseException.getPublicId());
        System.out.println("Sys  : " + sAXParseException.getSystemId());
        System.out.println("Line : " + sAXParseException.getLineNumber());
        System.out.println("Col  : " + sAXParseException.getColumnNumber());
        sAXParseException.printStackTrace();
    }

    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        System.out.println("FATAL ERROR in element " + sAXParseException.getPublicId());
        System.out.println("Sys  : " + sAXParseException.getSystemId());
        System.out.println("Line : " + sAXParseException.getLineNumber());
        System.out.println("Col  : " + sAXParseException.getColumnNumber());
        sAXParseException.printStackTrace();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void parse() throws SAXException, IOException {
        try {
            this.parser.setDocumentHandler(this);
            this.parser.setErrorHandler(this);
            this.parser.parse(new InputSource(this.reader));
        }
        finally {
            try {
                this.reader.close();
            }
            catch (IOException iOException) {}
        }
    }

    public Resource[] readResources() throws IOException, SerializationException {
        try {
            this.parse();
        }
        catch (SAXException sAXException) {
            sAXException.printStackTrace();
            return new Resource[0];
        }
        int n = this.holders.length;
        Resource[] resourceArray = new Resource[n];
        for (int i = 0; i < n; ++i) {
            resourceArray[i] = (Resource)this.holders[i];
        }
        return resourceArray;
    }

    public AttributeHolder[] readAttributeHolders() throws IOException, SerializationException {
        try {
            this.parse();
        }
        catch (SAXException sAXException) {
            sAXException.printStackTrace();
            return new AttributeHolder[0];
        }
        return this.holders;
    }

    public XMLReader(Reader reader, Parser parser) {
        this.reader = reader;
        this.parser = parser;
    }
}

