/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.jigsaw.filters;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPOutputStream;
import org.w3c.jigsaw.http.Reply;
import org.w3c.jigsaw.http.Request;
import org.w3c.tools.resources.AttributeRegistry;
import org.w3c.tools.resources.ProtocolException;
import org.w3c.tools.resources.ReplyInterface;
import org.w3c.tools.resources.RequestInterface;
import org.w3c.tools.resources.ResourceFilter;
import org.w3c.tools.resources.StringArrayAttribute;
import org.w3c.www.http.HttpAcceptEncoding;
import org.w3c.www.mime.MimeType;

public class TEFilter
extends ResourceFilter {
    protected static int ATTR_MIME_TYPES = -1;
    protected MimeType[] types = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValue(int n, Object object) {
        super.setValue(n, object);
        if (n == ATTR_MIME_TYPES) {
            TEFilter tEFilter = this;
            synchronized (tEFilter) {
                this.types = null;
            }
        }
    }

    public synchronized MimeType[] getMimeTypes() {
        if (this.types == null) {
            String[] stringArray = (String[])this.getValue(ATTR_MIME_TYPES, null);
            if (stringArray == null) {
                return null;
            }
            this.types = new MimeType[stringArray.length];
            for (int i = 0; i < this.types.length; ++i) {
                try {
                    this.types[i] = new MimeType(stringArray[i]);
                    continue;
                }
                catch (Exception exception) {
                    this.types[i] = null;
                }
            }
        }
        return this.types;
    }

    protected double getCompressibilityFactor(Reply reply) {
        MimeType[] mimeTypeArray = this.getMimeTypes();
        if (mimeTypeArray != null) {
            for (int i = 0; i < mimeTypeArray.length; ++i) {
                if (mimeTypeArray[i] == null || mimeTypeArray[i].match(reply.getContentType()) <= 0) continue;
                String[] stringArray = reply.getContentEncoding();
                if (stringArray != null) {
                    for (int j = 0; j < stringArray.length; ++j) {
                        if (stringArray[j].indexOf("gzip") < 0 && stringArray[j].indexOf("deflate") < 0 && stringArray[j].indexOf("compress") < 0) continue;
                        return 0.001;
                    }
                }
                return 1.0;
            }
        }
        return 0.001;
    }

    protected void doEncoding(HttpAcceptEncoding httpAcceptEncoding, Reply reply) {
        if (!reply.hasStream()) {
            return;
        }
        MimeType[] mimeTypeArray = this.getMimeTypes();
        boolean bl = false;
        if (mimeTypeArray != null) {
            for (int i = 0; i < mimeTypeArray.length; ++i) {
                if (mimeTypeArray[i] == null || mimeTypeArray[i].match(reply.getContentType()) <= 0) continue;
                bl = true;
                break;
            }
        }
        if (!bl) {
            return;
        }
        InputStream inputStream = reply.openStream();
        if (httpAcceptEncoding.getEncoding().equals("gzip")) {
            try {
                PipedOutputStream pipedOutputStream = new PipedOutputStream();
                PipedInputStream pipedInputStream = new PipedInputStream(pipedOutputStream);
                new DataMover(reply.openStream(), new GZIPOutputStream(pipedOutputStream));
                reply.setStream(pipedInputStream);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                reply.setStream(inputStream);
                return;
            }
            reply.addTransferEncoding("gzip");
            reply.setContentLength(-1);
        } else if (httpAcceptEncoding.getEncoding().equals("deflate")) {
            try {
                PipedOutputStream pipedOutputStream = new PipedOutputStream();
                PipedInputStream pipedInputStream = new PipedInputStream(pipedOutputStream);
                new DataMover(reply.openStream(), new DeflaterOutputStream(pipedOutputStream));
                reply.setStream(pipedInputStream);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                reply.setStream(inputStream);
                return;
            }
            reply.addTransferEncoding("deflate");
            reply.setContentLength(-1);
        }
    }

    public ReplyInterface outgoingFilter(RequestInterface requestInterface, ReplyInterface replyInterface) throws ProtocolException {
        Request request = (Request)requestInterface;
        Reply reply = (Reply)replyInterface;
        HttpAcceptEncoding[] httpAcceptEncodingArray = request.getTE();
        String[] stringArray = reply.getTransferEncoding();
        if (!reply.hasStream()) {
            return null;
        }
        if (stringArray != null) {
            return null;
        }
        if (httpAcceptEncodingArray != null) {
            double d = -1.0;
            double d2 = 1.0;
            double d3 = 1.0;
            double d4 = this.getCompressibilityFactor(reply);
            HttpAcceptEncoding httpAcceptEncoding = null;
            for (int i = 0; i < httpAcceptEncodingArray.length; ++i) {
                if (httpAcceptEncodingArray[i].getEncoding().equals("identity")) {
                    d2 = httpAcceptEncodingArray[i].getQuality();
                    continue;
                }
                if (httpAcceptEncodingArray[i].getEncoding().equals("chunked")) {
                    d3 = httpAcceptEncodingArray[i].getQuality();
                    continue;
                }
                if (httpAcceptEncodingArray[i].getEncoding().equals("trailers") || !(httpAcceptEncodingArray[i].getQuality() * d4 > d)) continue;
                httpAcceptEncoding = httpAcceptEncodingArray[i];
                d = httpAcceptEncodingArray[i].getQuality() * d4;
                if (d == 1.0) break;
            }
            if (httpAcceptEncoding != null && d >= d2) {
                this.doEncoding(httpAcceptEncoding, reply);
            } else if (d2 > 0.0) {
                if (d3 > d2) {
                    reply.setContentLength(-1);
                }
            } else {
                reply.setContentLength(-1);
            }
        }
        return null;
    }

    static {
        Class<?> clazz = null;
        StringArrayAttribute stringArrayAttribute = null;
        try {
            clazz = Class.forName("org.w3c.jigsaw.filters.TEFilter");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
        stringArrayAttribute = new StringArrayAttribute("mime-types", null, 2);
        ATTR_MIME_TYPES = AttributeRegistry.registerAttribute(clazz, stringArrayAttribute);
    }

    private class DataMover
    extends Thread {
        InputStream in = null;
        OutputStream out = null;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                byte[] byArray = new byte[1024];
                int n = -1;
                while ((n = this.in.read(byArray)) >= 0) {
                    this.out.write(byArray, 0, n);
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            finally {
                try {
                    this.in.close();
                }
                catch (Exception exception) {}
                try {
                    this.out.close();
                }
                catch (Exception exception) {}
            }
        }

        DataMover(InputStream inputStream, OutputStream outputStream) {
            this.in = inputStream;
            this.out = outputStream;
            this.setName("DataMover");
            this.start();
        }
    }
}

