/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.css.propertyvalue;

import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.string.ToStringGenerator;
import com.phloc.css.ICSSWriterSettings;
import com.phloc.css.property.ECSSProperty;
import com.phloc.css.property.ICSSProperty;
import com.phloc.css.propertyvalue.ICSSValue;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public final class CSSValue
implements ICSSValue {
    private static final Logger s_aLogger = LoggerFactory.getLogger(CSSValue.class);
    private final ICSSProperty m_aProperty;
    private final String m_sValue;
    private final boolean m_bIsImportant;

    public CSSValue(@Nonnull ICSSProperty aProperty, @Nonnull String sValue, boolean bIsImportant) {
        if (aProperty == null) {
            throw new NullPointerException("property");
        }
        if (!aProperty.isValidValue(sValue)) {
            s_aLogger.warn("CSS: the value '" + sValue + "' is not valid for property '" + aProperty.getProp().getName() + "'");
        }
        this.m_aProperty = aProperty;
        this.m_sValue = sValue + (bIsImportant ? " !important" : "");
        this.m_bIsImportant = bIsImportant;
    }

    @Nonnull
    public ICSSProperty getProperty() {
        return this.m_aProperty;
    }

    @Override
    @Nonnull
    public ECSSProperty getProp() {
        return this.m_aProperty.getProp();
    }

    public String getValue() {
        return this.m_sValue;
    }

    public boolean isImportant() {
        return this.m_bIsImportant;
    }

    @Override
    @Nonnull
    public String getAsCSSString(@Nonnull ICSSWriterSettings aSettings, @Nonnegative int nIndentLevel) {
        aSettings.checkVersionRequirements(this.m_aProperty);
        return this.m_aProperty.getProp().getName() + ':' + this.m_sValue + ';';
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CSSValue)) {
            return false;
        }
        CSSValue rhs = (CSSValue)o;
        return this.m_aProperty.getProp().equals(rhs.m_aProperty.getProp()) && this.m_sValue.equals(rhs.m_sValue);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Enum)this.m_aProperty.getProp()).append((Object)this.m_sValue).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("property", (Object)this.m_aProperty).append("value", (Object)this.m_sValue).append("important", this.m_bIsImportant).toString();
    }
}

