/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.css.parser;

import com.phloc.commons.regex.RegExHelper;
import com.phloc.commons.string.StringHelper;
import java.util.regex.Matcher;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class ParseUtils {
    private ParseUtils() {
    }

    @Nonnull
    private static String _trimBy(@Nonnull CharSequence s, int nLeftSkip, int nRightSkip) {
        return ((Object)s).toString().substring(nLeftSkip, s.length() - nRightSkip);
    }

    @Nullable
    public static String extractStringValue(@Nullable String sStr) {
        if (StringHelper.hasNoText((CharSequence)sStr) || sStr.length() < 2) {
            return sStr;
        }
        char cFirst = sStr.charAt(0);
        if ((cFirst == '\"' || cFirst == '\'') && StringHelper.getLastChar((CharSequence)sStr) == cFirst) {
            return ParseUtils._trimBy(sStr, 1, 1);
        }
        return sStr;
    }

    @Nonnull
    public static String trimUrl(@Nonnull CharSequence s) {
        String s1 = ParseUtils._trimBy(s, 4, 1).trim();
        return ParseUtils.extractStringValue(s1);
    }

    @Nonnull
    public static String splitNumber(@Nonnull StringBuilder aPattern) {
        String sRegEx = "^([0-9]*\\.[0-9]+|[0-9]+).*$";
        Matcher m = RegExHelper.getMatcher((String)"^([0-9]*\\.[0-9]+|[0-9]+).*$", (String)aPattern.toString());
        if (m.matches()) {
            return m.group(1);
        }
        return "";
    }
}

