/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.css.decl;

import com.phloc.commons.annotations.Nonempty;
import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.string.StringHelper;
import com.phloc.commons.string.ToStringGenerator;
import com.phloc.css.ICSSWriteable;
import com.phloc.css.ICSSWriterSettings;
import com.phloc.css.utils.CSSURLHelper;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class CSSURI
implements ICSSWriteable {
    private String m_sURI;

    public CSSURI(@Nonnull @Nonempty String sURI) {
        this.setURI(sURI);
    }

    @Nonnull
    @Nonempty
    public String getURI() {
        return this.m_sURI;
    }

    @Nonnull
    public void setURI(@Nonnull @Nonempty String sURI) {
        if (StringHelper.hasNoText((CharSequence)sURI)) {
            throw new IllegalArgumentException("URI may not be empty");
        }
        if (CSSURLHelper.isURLValue(sURI)) {
            throw new IllegalArgumentException("Only the URI and not the CSS URI value must be passed!");
        }
        this.m_sURI = sURI;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getAsCSSString(@Nonnull ICSSWriterSettings aSettings, @Nonnegative int nIndentLevel) {
        return CSSURLHelper.getAsCSSURL(this.m_sURI, aSettings.isQuoteURLs());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CSSURI)) {
            return false;
        }
        CSSURI rhs = (CSSURI)o;
        return this.m_sURI.equals(rhs.m_sURI);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_sURI).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("URI", (Object)this.m_sURI).toString();
    }
}

