/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.css.decl;

import com.phloc.commons.annotations.Nonempty;
import com.phloc.commons.equals.EqualsUtils;
import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.string.StringHelper;
import com.phloc.commons.string.ToStringGenerator;
import com.phloc.css.ICSSWriterSettings;
import com.phloc.css.decl.ECSSAttributeOperator;
import com.phloc.css.decl.ICSSSelectorMember;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class CSSSelectorAttribute
implements ICSSSelectorMember {
    private final String m_sAttrName;
    private final ECSSAttributeOperator m_eOperator;
    private final String m_sAttrValue;

    public CSSSelectorAttribute(@Nonnull @Nonempty String sAttrName) {
        if (StringHelper.hasNoText((CharSequence)sAttrName)) {
            throw new IllegalArgumentException("attrName");
        }
        this.m_sAttrName = sAttrName;
        this.m_eOperator = null;
        this.m_sAttrValue = null;
    }

    public CSSSelectorAttribute(@Nonnull @Nonempty String sAttrName, @Nonnull ECSSAttributeOperator eOperator, @Nonnull String sAttrValue) {
        if (StringHelper.hasNoText((CharSequence)sAttrName)) {
            throw new IllegalArgumentException("attrName");
        }
        if (eOperator == null) {
            throw new NullPointerException("operator");
        }
        if (sAttrValue == null) {
            throw new NullPointerException("attrValue");
        }
        this.m_sAttrName = sAttrName;
        this.m_eOperator = eOperator;
        this.m_sAttrValue = sAttrValue;
    }

    @Nonnull
    @Nonempty
    public String getAttrName() {
        return this.m_sAttrName;
    }

    @Nullable
    public ECSSAttributeOperator getOperator() {
        return this.m_eOperator;
    }

    @Nullable
    public String getAttrValue() {
        return this.m_sAttrValue;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getAsCSSString(@Nonnull ICSSWriterSettings aSettings, @Nonnegative int nIndentLevel) {
        if (this.m_eOperator == null) {
            return "[" + this.m_sAttrName + "]";
        }
        return "[" + this.m_sAttrName + this.m_eOperator.getAsCSSString(aSettings, nIndentLevel) + this.m_sAttrValue + "]";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CSSSelectorAttribute)) {
            return false;
        }
        CSSSelectorAttribute rhs = (CSSSelectorAttribute)o;
        return this.m_sAttrName.equals(rhs.m_sAttrName) && EqualsUtils.equals((Object)this.m_eOperator, (Object)rhs.m_eOperator) && EqualsUtils.equals((Object)this.m_sAttrValue, (Object)rhs.m_sAttrValue);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_sAttrName).append((Enum)this.m_eOperator).append((Object)this.m_sAttrValue).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(null).append("attrName", (Object)this.m_sAttrName).appendIfNotNull("operator", (Object)this.m_eOperator).appendIfNotNull("attrValue", (Object)this.m_sAttrValue).toString();
    }
}

