/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.css.decl;

import com.phloc.commons.annotations.Nonempty;
import com.phloc.commons.equals.EqualsUtils;
import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.string.StringHelper;
import com.phloc.commons.string.ToStringGenerator;
import com.phloc.css.ICSSWriterSettings;
import com.phloc.css.decl.CSSExpression;
import com.phloc.css.decl.ICSSExpressionMember;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class CSSExpressionMemberFunction
implements ICSSExpressionMember {
    private final String m_sFunctionName;
    private final CSSExpression m_aExpression;

    @Nonnull
    private static String _skipBrackets(@Nonnull String sName) {
        String sRealName = sName.trim();
        if (sRealName.length() > 2 && sRealName.endsWith("()")) {
            return sRealName.substring(0, sRealName.length() - 2).trim();
        }
        return sRealName;
    }

    public CSSExpressionMemberFunction(@Nonnull @Nonempty String sFunctionName) {
        this(sFunctionName, null);
    }

    public CSSExpressionMemberFunction(@Nonnull @Nonempty String sFunctionName, @Nullable CSSExpression aExpression) {
        if (StringHelper.hasNoText((CharSequence)sFunctionName)) {
            throw new IllegalArgumentException("Empty function name is not allowed");
        }
        this.m_sFunctionName = CSSExpressionMemberFunction._skipBrackets(sFunctionName);
        this.m_aExpression = aExpression;
    }

    @Nonnull
    @Nonempty
    public String getFunctionName() {
        return this.m_sFunctionName;
    }

    @Nullable
    public CSSExpression getExpression() {
        return this.m_aExpression;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getAsCSSString(@Nonnull ICSSWriterSettings aSettings, @Nonnegative int nIndentLevel) {
        if (this.m_aExpression == null) {
            return this.m_sFunctionName + "()";
        }
        return this.m_sFunctionName + "(" + this.m_aExpression.getAsCSSString(aSettings, nIndentLevel) + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CSSExpressionMemberFunction)) {
            return false;
        }
        CSSExpressionMemberFunction rhs = (CSSExpressionMemberFunction)o;
        return this.m_sFunctionName.equals(rhs.m_sFunctionName) && EqualsUtils.equals((Object)this.m_aExpression, (Object)rhs.m_aExpression);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_sFunctionName).append((Object)this.m_aExpression).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(null).append("funcName", (Object)this.m_sFunctionName).appendIfNotNull("expression", (Object)this.m_aExpression).toString();
    }
}

