/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.css.decl;

import com.phloc.commons.annotations.Nonempty;
import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.string.StringHelper;
import com.phloc.commons.string.ToStringGenerator;
import com.phloc.css.ICSSWriteable;
import com.phloc.css.ICSSWriterSettings;
import com.phloc.css.decl.CSSExpression;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class CSSDeclaration
implements ICSSWriteable {
    private final String m_sProperty;
    private final CSSExpression m_aExpression;
    private final boolean m_bImportant;

    public CSSDeclaration(@Nonnull @Nonempty String sProperty, @Nonnull CSSExpression aExpression, boolean bImportant) {
        if (StringHelper.hasNoText((CharSequence)sProperty)) {
            throw new IllegalArgumentException("empty property is not allowed");
        }
        if (aExpression == null) {
            throw new NullPointerException("expression");
        }
        this.m_sProperty = sProperty.toLowerCase();
        this.m_aExpression = aExpression;
        this.m_bImportant = bImportant;
    }

    @Nonnull
    @Nonempty
    public String getProperty() {
        return this.m_sProperty;
    }

    @Nonnull
    public CSSExpression getExpression() {
        return this.m_aExpression;
    }

    public boolean isImportant() {
        return this.m_bImportant;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getAsCSSString(@Nonnull ICSSWriterSettings aSettings, @Nonnegative int nIndentLevel) {
        return this.m_sProperty + ':' + this.m_aExpression.getAsCSSString(aSettings, nIndentLevel) + (this.m_bImportant ? " !important" : "") + ';';
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CSSDeclaration)) {
            return false;
        }
        CSSDeclaration rhs = (CSSDeclaration)o;
        return this.m_sProperty.equals(rhs.m_sProperty) && this.m_aExpression.equals(rhs.m_aExpression) && this.m_bImportant == rhs.m_bImportant;
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_sProperty).append((Object)this.m_aExpression).append(this.m_bImportant).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("property", (Object)this.m_sProperty).append("expression", (Object)this.m_aExpression).append("important", this.m_bImportant).toString();
    }
}

