/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.xml.transform;

import com.phloc.commons.io.EAppend;
import com.phloc.commons.io.IOutputStreamProvider;
import com.phloc.commons.io.IWritableResource;
import com.phloc.commons.string.ToStringGenerator;
import java.io.OutputStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import javax.xml.transform.stream.StreamResult;

@NotThreadSafe
public final class ResourceStreamResult
extends StreamResult {
    private final IOutputStreamProvider m_aOSP;

    public ResourceStreamResult(@Nonnull IWritableResource aResource) {
        this(aResource, aResource.getResourceID());
    }

    public ResourceStreamResult(@Nonnull IOutputStreamProvider aOSP, @Nullable String sSystemID) {
        if (aOSP == null) {
            throw new NullPointerException("resource");
        }
        this.m_aOSP = aOSP;
        this.setSystemId(sSystemID);
    }

    @Override
    public OutputStream getOutputStream() {
        OutputStream aOS = this.m_aOSP.getOutputStream(EAppend.TRUNCATE);
        if (aOS == null) {
            throw new IllegalStateException("Failed to open output stream for " + this.m_aOSP);
        }
        return aOS;
    }

    public String toString() {
        return new ToStringGenerator(this).append("OSP", this.m_aOSP).append("systemID", this.getSystemId()).toString();
    }
}

