/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.xml.serialize;

import com.phloc.commons.exceptions.InitializationException;
import com.phloc.commons.factory.IFactory;
import com.phloc.commons.io.IReadableResource;
import com.phloc.commons.io.streams.StreamUtils;
import com.phloc.commons.pool.IObjectPool;
import com.phloc.commons.pool.ObjectPool;
import com.phloc.commons.state.ESuccess;
import com.phloc.commons.stats.IStatisticsHandlerCounter;
import com.phloc.commons.stats.IStatisticsHandlerTimer;
import com.phloc.commons.stats.StatisticsManager;
import com.phloc.commons.timing.StopWatch;
import com.phloc.commons.xml.EXMLParserFeature;
import com.phloc.commons.xml.XMLFactory;
import com.phloc.commons.xml.sax.CollectingSAXErrorHandler;
import com.phloc.commons.xml.sax.InputSourceFactory;
import com.phloc.commons.xml.sax.LoggingSAXErrorHandler;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.UnknownHostException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.WillClose;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.validation.Schema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public final class XMLReader {
    private static final Logger s_aLogger = LoggerFactory.getLogger(XMLReader.class);
    private static final IStatisticsHandlerTimer s_aSaxTimerHdl = StatisticsManager.getTimerHandler(XMLReader.class.getName() + "$SAX");
    private static final IStatisticsHandlerCounter s_aSaxErrorCounterHdl = StatisticsManager.getCounterHandler(XMLReader.class.getName() + "$SAXERRORS");
    private static final IStatisticsHandlerTimer s_aDomTimerHdl = StatisticsManager.getTimerHandler(XMLReader.class.getName() + "$DOM");
    private static final IStatisticsHandlerTimer s_aDomSchemaTimerHdl = StatisticsManager.getTimerHandler(XMLReader.class.getName() + "$DOMwithSchema");
    private static final IStatisticsHandlerCounter s_aDomErrorCounterHdl = StatisticsManager.getCounterHandler(XMLReader.class.getName() + "$DOMERRORS");
    private static IFactory<org.xml.sax.XMLReader> s_aXMLReaderFactry = new IFactory<org.xml.sax.XMLReader>(){

        @Override
        public org.xml.sax.XMLReader create() {
            try {
                org.xml.sax.XMLReader ret = XMLReaderFactory.createXMLReader();
                ret.setErrorHandler(LoggingSAXErrorHandler.getInstance());
                return ret;
            }
            catch (SAXException ex) {
                throw new InitializationException("Failed to instantiate XML reader!", ex);
            }
        }
    };
    private static IObjectPool<org.xml.sax.XMLReader> s_aPool = new ObjectPool<org.xml.sax.XMLReader>(5, s_aXMLReaderFactry);
    private static final XMLReader s_aInstance = new XMLReader();

    private XMLReader() {
    }

    @Nullable
    public static Document readXMLDOM(@WillClose @Nonnull InputSource aIS) throws SAXException {
        return XMLReader.readXMLDOM(aIS, null, null);
    }

    @Nullable
    public static Document readXMLDOM(@Nonnull @WillClose InputStream aIS) throws SAXException {
        return XMLReader.readXMLDOM(aIS, null, null);
    }

    @Nullable
    public static Document readXMLDOM(@Nonnull File aFile) throws SAXException {
        return XMLReader.readXMLDOM(aFile, null, null);
    }

    @Nullable
    public static Document readXMLDOM(@Nonnull IReadableResource aIIS) throws SAXException {
        return XMLReader.readXMLDOM(aIIS, null, null);
    }

    @Nullable
    public static Document readXMLDOM(@WillClose @Nonnull Reader aReader) throws SAXException {
        return XMLReader.readXMLDOM(aReader, null, null);
    }

    @Nullable
    public static Document readXMLDOM(@Nonnull String sXML) throws SAXException {
        return XMLReader.readXMLDOM(sXML, null, null);
    }

    @Nullable
    public static Document readXMLDOM(@Nonnull byte[] aXML) throws SAXException {
        return XMLReader.readXMLDOM(aXML, null, null);
    }

    @Nullable
    public static Document readXMLDOM(@WillClose @Nonnull InputSource aIS, @Nullable Schema aSchema) throws SAXException {
        return XMLReader.readXMLDOM(aIS, aSchema, null);
    }

    @Nullable
    public static Document readXMLDOM(@WillClose @Nonnull InputStream aIS, @Nullable Schema aSchema) throws SAXException {
        return XMLReader.readXMLDOM(aIS, aSchema, null);
    }

    @Nullable
    public static Document readXMLDOM(@Nonnull File aFile, @Nullable Schema aSchema) throws SAXException {
        return XMLReader.readXMLDOM(aFile, aSchema, null);
    }

    @Nullable
    public static Document readXMLDOM(@Nonnull IReadableResource aISP, @Nullable Schema aSchema) throws SAXException {
        return XMLReader.readXMLDOM(aISP, aSchema, null);
    }

    @Nullable
    public static Document readXMLDOM(@WillClose @Nonnull Reader aReader, @Nullable Schema aSchema) throws SAXException {
        return XMLReader.readXMLDOM(aReader, aSchema, null);
    }

    @Nullable
    public static Document readXMLDOM(@Nonnull String sXML, @Nullable Schema aSchema) throws SAXException {
        return XMLReader.readXMLDOM(sXML, aSchema, null);
    }

    @Nullable
    public static Document readXMLDOM(@Nonnull byte[] aXML, @Nullable Schema aSchema) throws SAXException {
        return XMLReader.readXMLDOM(aXML, aSchema, null);
    }

    @Nullable
    public static Document readXMLDOM(@WillClose @Nonnull InputSource aIS, @Nullable ErrorHandler aCustomErrorHandler) throws SAXException {
        return XMLReader.readXMLDOM(aIS, null, aCustomErrorHandler);
    }

    @Nullable
    public static Document readXMLDOM(@WillClose @Nonnull InputStream aIS, @Nullable ErrorHandler aCustomErrorHandler) throws SAXException {
        return XMLReader.readXMLDOM(aIS, null, aCustomErrorHandler);
    }

    @Nullable
    public static Document readXMLDOM(@Nonnull File aFile, @Nullable ErrorHandler aCustomErrorHandler) throws SAXException {
        return XMLReader.readXMLDOM(aFile, null, aCustomErrorHandler);
    }

    @Nullable
    public static Document readXMLDOM(@Nonnull IReadableResource aISP, @Nullable ErrorHandler aCustomErrorHandler) throws SAXException {
        return XMLReader.readXMLDOM(aISP, null, aCustomErrorHandler);
    }

    @Nullable
    public static Document readXMLDOM(@WillClose @Nonnull Reader aReader, @Nullable ErrorHandler aCustomErrorHandler) throws SAXException {
        return XMLReader.readXMLDOM(aReader, null, aCustomErrorHandler);
    }

    @Nullable
    public static Document readXMLDOM(@Nonnull String sXML, @Nullable ErrorHandler aCustomErrorHandler) throws SAXException {
        return XMLReader.readXMLDOM(sXML, null, aCustomErrorHandler);
    }

    @Nullable
    public static Document readXMLDOM(@Nonnull byte[] aXML, @Nullable ErrorHandler aCustomErrorHandler) throws SAXException {
        return XMLReader.readXMLDOM(aXML, null, aCustomErrorHandler);
    }

    @Nullable
    public static Document readXMLDOM(@WillClose @Nonnull InputSource aInputSource, @Nullable Schema aSchema, @Nullable ErrorHandler aCustomErrorHandler) throws SAXException {
        if (aInputSource == null) {
            throw new NullPointerException("inputSource");
        }
        Document doc = null;
        try {
            DocumentBuilder aDocumentBuilder;
            StopWatch aSW = new StopWatch(true);
            DocumentBuilder documentBuilder = aDocumentBuilder = aSchema == null ? XMLFactory.getDocumentBuilder() : XMLFactory.createDocumentBuilder(aSchema);
            CollectingSAXErrorHandler aCEH = aCustomErrorHandler instanceof CollectingSAXErrorHandler ? (CollectingSAXErrorHandler)aCustomErrorHandler : new CollectingSAXErrorHandler(aCustomErrorHandler != null ? aCustomErrorHandler : LoggingSAXErrorHandler.getInstance());
            aDocumentBuilder.setErrorHandler(aCEH);
            doc = aDocumentBuilder.parse(aInputSource);
            if (aSchema == null) {
                s_aDomTimerHdl.addTime(aSW.stopAndGetMillis());
            } else {
                s_aDomSchemaTimerHdl.addTime(aSW.stopAndGetMillis());
            }
            if (aCEH.getResourceErrors().containsAtLeastOneError()) {
                return null;
            }
        }
        catch (SAXException ex) {
            s_aLogger.error("Invalid XML document", (Throwable)ex);
            s_aDomErrorCounterHdl.increment();
            throw ex;
        }
        catch (IOException ex) {
            s_aLogger.error("Error reading XML document", (Throwable)ex);
            s_aDomErrorCounterHdl.increment();
        }
        return doc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static Document readXMLDOM(@Nonnull @WillClose InputStream aIS, @Nullable Schema aSchema, @Nullable ErrorHandler aCustomErrorHandler) throws SAXException {
        if (aIS == null) {
            throw new NullPointerException("inputStream");
        }
        try {
            Document document = XMLReader.readXMLDOM(InputSourceFactory.create(aIS), aSchema, aCustomErrorHandler);
            return document;
        }
        finally {
            StreamUtils.close(aIS);
        }
    }

    @Nullable
    public static Document readXMLDOM(@Nonnull File aFile, @Nullable Schema aSchema, @Nullable ErrorHandler aCustomErrorHandler) throws SAXException {
        if (aFile == null) {
            throw new NullPointerException("file");
        }
        return XMLReader.readXMLDOM(InputSourceFactory.create(aFile), aSchema, aCustomErrorHandler);
    }

    @Nullable
    public static Document readXMLDOM(@Nonnull IReadableResource aResource, @Nullable Schema aSchema, @Nullable ErrorHandler aCustomErrorHandler) throws SAXException {
        if (aResource == null) {
            throw new NullPointerException("resource");
        }
        return XMLReader.readXMLDOM(InputSourceFactory.create(aResource), aSchema, aCustomErrorHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static Document readXMLDOM(@Nonnull @WillClose Reader aReader, @Nullable Schema aSchema, @Nullable ErrorHandler aCustomErrorHandler) throws SAXException {
        if (aReader == null) {
            throw new NullPointerException("reader");
        }
        try {
            Document document = XMLReader.readXMLDOM(InputSourceFactory.create(aReader), aSchema, aCustomErrorHandler);
            return document;
        }
        finally {
            StreamUtils.close(aReader);
        }
    }

    @Nullable
    public static Document readXMLDOM(@Nonnull String sXML, @Nullable Schema aSchema, @Nullable ErrorHandler aCustomErrorHandler) throws SAXException {
        if (sXML == null) {
            throw new NullPointerException("xml");
        }
        return XMLReader.readXMLDOM(InputSourceFactory.create(sXML), aSchema, aCustomErrorHandler);
    }

    @Nullable
    public static Document readXMLDOM(@Nonnull byte[] aXML, @Nullable Schema aSchema, @Nullable ErrorHandler aCustomErrorHandler) throws SAXException {
        if (aXML == null) {
            throw new NullPointerException("xml");
        }
        return XMLReader.readXMLDOM(InputSourceFactory.create(aXML), aSchema, aCustomErrorHandler);
    }

    @Nonnull
    public static ESuccess readXMLSAX(@WillClose @Nonnull InputStream aIS, EntityResolver aEntityResolver, DTDHandler aDTDHdl, ContentHandler aContentHdl, ErrorHandler aErrorHdl, LexicalHandler aLexicalHdl, boolean bDTDValidating, boolean bSchemaValidating) {
        if (aIS == null) {
            throw new NullPointerException("inputStream");
        }
        return XMLReader.readXMLSAX(InputSourceFactory.create(aIS), aEntityResolver, aDTDHdl, aContentHdl, aErrorHdl, aLexicalHdl, bDTDValidating, bSchemaValidating);
    }

    private static void _setSAXFeature(@Nonnull org.xml.sax.XMLReader aParser, @Nonnull EXMLParserFeature eFeature, boolean bValue) {
        try {
            aParser.setFeature(eFeature.getName(), bValue);
        }
        catch (SAXNotRecognizedException ex) {
            s_aLogger.warn("XML Parser does not recognize feature '" + eFeature + "'");
        }
        catch (SAXNotSupportedException ex) {
            s_aLogger.warn("XML Parser does not support feature '" + eFeature + "'");
        }
    }

    private static void _setSAXProperty(@Nonnull org.xml.sax.XMLReader aParser, @Nonnull EXMLParserFeature eFeature, Object aValue) {
        try {
            aParser.setProperty(eFeature.getName(), aValue);
        }
        catch (SAXNotRecognizedException ex) {
            s_aLogger.warn("XML Parser does not recognize property '" + eFeature + "'");
        }
        catch (SAXNotSupportedException ex) {
            s_aLogger.warn("XML Parser does not support property '" + eFeature + "'");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public static ESuccess readXMLSAX(@WillClose @Nonnull InputSource aIS, EntityResolver aEntityResolver, DTDHandler aDTDHdl, ContentHandler aContentHdl, ErrorHandler aErrorHdl, LexicalHandler aLexicalHdl, boolean bDTDValidating, boolean bSchemaValidating) {
        block18: {
            if (aIS == null) {
                throw new NullPointerException("inputStream");
            }
            try {
                ESuccess eSuccess;
                org.xml.sax.XMLReader aParser = s_aPool.borrowObject();
                if (aParser == null) {
                    s_aLogger.error("Failed to get parser from pool!");
                    ESuccess eSuccess2 = ESuccess.FAILURE;
                    return eSuccess2;
                }
                try {
                    StopWatch aSW = new StopWatch(true);
                    aParser.setContentHandler(aContentHdl);
                    aParser.setDTDHandler(aDTDHdl);
                    aParser.setEntityResolver(aEntityResolver);
                    aParser.setErrorHandler(aErrorHdl);
                    XMLReader._setSAXFeature(aParser, EXMLParserFeature.SAX_FEATURE_NAMESPACES, true);
                    XMLReader._setSAXFeature(aParser, EXMLParserFeature.SAX_FEATURE_NAMESPACE_PREFIXES, true);
                    XMLReader._setSAXFeature(aParser, EXMLParserFeature.SAX_FEATURE_VALIDATION, bDTDValidating);
                    XMLReader._setSAXFeature(aParser, EXMLParserFeature.SAX_FEATURE_SCHEMA_VALIDATION, bSchemaValidating);
                    if (aLexicalHdl != null) {
                        XMLReader._setSAXProperty(aParser, EXMLParserFeature.SAX_FEATURE_LEXICAL_HANDLER, aLexicalHdl);
                    }
                    aParser.parse(aIS);
                    s_aSaxTimerHdl.addTime(aSW.stopAndGetMillis());
                    eSuccess = ESuccess.SUCCESS;
                    s_aPool.returnObject(aParser);
                }
                catch (Throwable throwable) {
                    try {
                        s_aPool.returnObject(aParser);
                        throw throwable;
                    }
                    catch (SAXParseException ex) {
                        s_aLogger.error("Error parsing XML at position (" + ex.getLineNumber() + "," + ex.getColumnNumber() + ")", (Throwable)ex);
                        break block18;
                    }
                    catch (SAXException ex) {
                        s_aLogger.error("Error parsing XML", (Throwable)ex);
                        break block18;
                    }
                    catch (UnknownHostException ex) {
                        s_aLogger.error("Failed to resolve entity host: " + ex.getMessage());
                        break block18;
                    }
                    catch (IOException ex) {
                        s_aLogger.error("Error reading XML", (Throwable)ex);
                        break block18;
                    }
                }
                return eSuccess;
            }
            finally {
                StreamUtils.close(aIS.getByteStream());
                StreamUtils.close(aIS.getCharacterStream());
            }
        }
        s_aSaxErrorCounterHdl.increment();
        return ESuccess.FAILURE;
    }
}

