/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.xml.namespace;

import com.phloc.commons.collections.ContainerHelper;
import com.phloc.commons.collections.iterate.SingleElementIterator;
import java.util.Iterator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.namespace.NamespaceContext;

public abstract class AbstractNamespaceContext
implements NamespaceContext {
    @Nullable
    public abstract String getDefaultNamespaceURI();

    @Nullable
    protected abstract Iterator<String> getCustomPrefixes(@Nonnull String var1);

    @Nonnull
    public final Iterator<?> getPrefixes(@Nonnull String sNamespaceURI) {
        if (sNamespaceURI == null) {
            throw new IllegalArgumentException();
        }
        if (sNamespaceURI.equals("http://www.w3.org/XML/1998/namespace")) {
            return SingleElementIterator.create("xml");
        }
        if (sNamespaceURI.equals("http://www.w3.org/2000/xmlns/")) {
            return SingleElementIterator.create("xmlns");
        }
        Iterator<String> ret = this.getCustomPrefixes(sNamespaceURI);
        return ret != null ? ret : ContainerHelper.getEmptyIterator();
    }

    @Nullable
    protected abstract String getCustomPrefix(@Nonnull String var1);

    @Override
    @Nullable
    public final String getPrefix(@Nonnull String sNamespaceURI) {
        if (sNamespaceURI == null) {
            throw new IllegalArgumentException();
        }
        if (sNamespaceURI.equals("http://www.w3.org/XML/1998/namespace")) {
            return "xml";
        }
        if (sNamespaceURI.equals("http://www.w3.org/2000/xmlns/")) {
            return "xmlns";
        }
        if (sNamespaceURI.equals(this.getDefaultNamespaceURI())) {
            return "";
        }
        return this.getCustomPrefix(sNamespaceURI);
    }

    @Nullable
    protected abstract String getCustomNamespaceURI(@Nonnull String var1);

    @Override
    @Nonnull
    public final String getNamespaceURI(@Nonnull String sPrefix) {
        if (sPrefix == null) {
            throw new IllegalArgumentException();
        }
        if (sPrefix.equals("xml")) {
            return "http://www.w3.org/XML/1998/namespace";
        }
        if (sPrefix.equals("xmlns")) {
            return "http://www.w3.org/2000/xmlns/";
        }
        if (sPrefix.equals("")) {
            String sDefNSURI = this.getDefaultNamespaceURI();
            return sDefNSURI != null ? sDefNSURI : "";
        }
        String ret = this.getCustomNamespaceURI(sPrefix);
        return ret != null ? ret : "";
    }
}

