/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.xml;

import com.phloc.commons.annotations.Nonempty;
import com.phloc.commons.collections.ArrayHelper;
import com.phloc.commons.collections.ContainerHelper;
import com.phloc.commons.collections.iterate.IIterableIterator;
import com.phloc.commons.string.StringHelper;
import com.phloc.commons.xml.CXML;
import com.phloc.commons.xml.ChildElementIterator;
import com.phloc.commons.xml.EXMLIncorrectCharacterHandling;
import com.phloc.commons.xml.EXMLVersion;
import com.phloc.commons.xml.FilterElementWithNamespace;
import com.phloc.commons.xml.FilterElementWithNamespaceAndLocalName;
import com.phloc.commons.xml.FilterElementWithTagName;
import com.phloc.commons.xml.FilterElementWithoutNamespace;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.w3c.dom.Attr;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

@Immutable
public final class XMLHelper {
    private static final char[] MASK_PATTERNS_XML10 = new char[]{'\u0000', '&', '<', '>', '\"', '\''};
    private static final char[] MASK_PATTERNS_CONTROL = new char[]{'\u0001', '\u0002', '\u0003', '\u0004', '\u0005', '\u0006', '\u0007', '\b', '\u000b', '\f', '\u000e', '\u000f', '\u0010', '\u0011', '\u0012', '\u0013', '\u0014', '\u0015', '\u0016', '\u0017', '\u0018', '\u0019', '\u001a', '\u001b', '\u001c', '\u001d', '\u001e', '\u001f', '\u2028'};
    private static final char[] MASK_PATTERNS_ALL = ArrayHelper.getConcatenated(MASK_PATTERNS_XML10, MASK_PATTERNS_CONTROL);
    private static final char[][] MASK_REPLACE_XML10 = new char[][]{"".toCharArray(), "&amp;".toCharArray(), "&lt;".toCharArray(), "&gt;".toCharArray(), "&quot;".toCharArray(), "&#39;".toCharArray()};
    private static final char[][] MASK_REPLACE_CONTROL_EMPTY = new char[][]{"".toCharArray(), "".toCharArray(), "".toCharArray(), "".toCharArray(), "".toCharArray(), "".toCharArray(), "".toCharArray(), "".toCharArray(), "".toCharArray(), "".toCharArray(), "".toCharArray(), "".toCharArray(), "".toCharArray(), "".toCharArray(), "".toCharArray(), "".toCharArray(), "".toCharArray(), "".toCharArray(), "".toCharArray(), "".toCharArray(), "".toCharArray(), "".toCharArray(), "".toCharArray(), "".toCharArray(), "".toCharArray(), "".toCharArray(), "".toCharArray(), "".toCharArray(), "\n".toCharArray()};
    private static final char[][] MASK_REPLACE_ALL_EMPTY = ArrayHelper.getConcatenated(MASK_REPLACE_XML10, MASK_REPLACE_CONTROL_EMPTY);
    private static final char[][] MASK_REPLACE_CONTROL_XML11 = new char[][]{"&#1;".toCharArray(), "&#2;".toCharArray(), "&#3;".toCharArray(), "&#4;".toCharArray(), "&#5;".toCharArray(), "&#6;".toCharArray(), "&#7;".toCharArray(), "&#8;".toCharArray(), "&#11;".toCharArray(), "&#12;".toCharArray(), "&#14;".toCharArray(), "&#15;".toCharArray(), "&#16;".toCharArray(), "&#17;".toCharArray(), "&#18;".toCharArray(), "&#19;".toCharArray(), "&#20;".toCharArray(), "&#21;".toCharArray(), "&#22;".toCharArray(), "&#23;".toCharArray(), "&#24;".toCharArray(), "&#25;".toCharArray(), "&#26;".toCharArray(), "&#27;".toCharArray(), "&#28;".toCharArray(), "&#29;".toCharArray(), "&#30;".toCharArray(), "&#31;".toCharArray(), "&#2028;".toCharArray()};
    private static final char[][] MASK_REPLACE_ALL_XML11 = ArrayHelper.getConcatenated(MASK_REPLACE_XML10, MASK_REPLACE_CONTROL_XML11);
    private static final boolean[] ILLEGAL_XML_CHARS = new boolean[]{true, true, true, true, true, true, true, true, true, false, false, true, true, false, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false};
    private static final XMLHelper s_aInstance;

    private XMLHelper() {
    }

    @Nullable
    public static Element getFirstChildElement(@Nonnull Node aStartNode) {
        NodeList aNodeList = aStartNode.getChildNodes();
        int nLen = aNodeList.getLength();
        for (int i = 0; i < nLen; ++i) {
            Node aNode = aNodeList.item(i);
            if (aNode.getNodeType() != 1) continue;
            return (Element)aNode;
        }
        return null;
    }

    public static boolean hasChildElementNodes(@Nonnull Node aStartNode) {
        return XMLHelper.getFirstChildElement(aStartNode) != null;
    }

    @Nullable
    public static Element getFirstChildElementOfName(@Nonnull Node aStartNode, @Nullable String sName) {
        NodeList aNodeList = aStartNode.getChildNodes();
        int nLen = aNodeList.getLength();
        for (int i = 0; i < nLen; ++i) {
            Element aElement;
            Node aNode = aNodeList.item(i);
            if (aNode.getNodeType() != 1 || !(aElement = (Element)aNode).getTagName().equals(sName)) continue;
            return aElement;
        }
        return null;
    }

    @Nullable
    public static Document getOwnerDocument(@Nullable Node aNode) {
        return aNode == null ? null : (aNode instanceof Document ? (Document)aNode : aNode.getOwnerDocument());
    }

    @Nonnull
    public static Node append(@Nonnull Node aParentNode, @Nullable Object aChild) {
        if (aParentNode == null) {
            throw new NullPointerException("parentNode");
        }
        if (aChild != null) {
            if (aChild instanceof Document) {
                XMLHelper.append(aParentNode, ((Document)aChild).getDocumentElement());
            } else if (aChild instanceof Node) {
                Node aChildNode = (Node)aChild;
                Document aParentDoc = XMLHelper.getOwnerDocument(aParentNode);
                if (XMLHelper.getOwnerDocument(aChildNode).equals(aParentDoc)) {
                    aParentNode.appendChild(aChildNode);
                } else {
                    aParentNode.appendChild(aParentDoc.adoptNode(aChildNode.cloneNode(true)));
                }
            } else if (aChild instanceof String) {
                aParentNode.appendChild(XMLHelper.getOwnerDocument(aParentNode).createTextNode((String)aChild));
            } else if (aChild instanceof Iterable) {
                for (Object aSubChild : (Iterable)aChild) {
                    XMLHelper.append(aParentNode, aSubChild);
                }
            } else if (ArrayHelper.isArray(aChild)) {
                for (Object aSubChild : (Object[])aChild) {
                    XMLHelper.append(aParentNode, aSubChild);
                }
            } else {
                throw new IllegalArgumentException("Passed object cannot be appended to a DOMNode (type=" + aChild.getClass().getName() + ".");
            }
        }
        return aParentNode;
    }

    public static void append(@Nonnull Node aSrcNode, @Nonnull Collection<?> aNodesToAppend) {
        for (Object aNode : aNodesToAppend) {
            XMLHelper.append(aSrcNode, aNode);
        }
    }

    @Nonnegative
    public static int getDirectChildElementCountNoNS(@Nullable Element aParent) {
        return aParent == null ? 0 : ContainerHelper.getSize(XMLHelper.getChildElementIteratorNoNS(aParent));
    }

    @Nonnegative
    public static int getDirectChildElementCountNoNS(@Nullable Element aParent, @Nonnull @Nonempty String sTagName) {
        return aParent == null ? 0 : ContainerHelper.getSize(XMLHelper.getChildElementIteratorNoNS(aParent, sTagName));
    }

    @Nonnegative
    public static int getDirectChildElementCountNS(@Nullable Element aParent, @Nullable String sNamespaceURI) {
        return aParent == null ? 0 : ContainerHelper.getSize(XMLHelper.getChildElementIteratorNS(aParent, sNamespaceURI));
    }

    @Nonnegative
    public static int getDirectChildElementCountNS(@Nullable Element aParent, @Nullable String sNamespaceURI, @Nonnull @Nonempty String sLocalName) {
        return aParent == null ? 0 : ContainerHelper.getSize(XMLHelper.getChildElementIteratorNS(aParent, sNamespaceURI, sLocalName));
    }

    @Nonnull
    public static IIterableIterator<Element> getChildElementIteratorNoNS(@Nonnull Node aStartNode) {
        return new ChildElementIterator(aStartNode, FilterElementWithoutNamespace.getInstance());
    }

    @Nonnull
    public static IIterableIterator<Element> getChildElementIteratorNoNS(@Nonnull Node aStartNode, @Nonnull @Nonempty String sTagName) {
        if (StringHelper.hasNoText(sTagName)) {
            throw new IllegalArgumentException("Passed tag name is illegal");
        }
        return new ChildElementIterator(aStartNode, new FilterElementWithTagName(sTagName));
    }

    @Nonnull
    public static IIterableIterator<Element> getChildElementIteratorNS(@Nonnull Node aStartNode, @Nullable String sNamespaceURI) {
        return new ChildElementIterator(aStartNode, new FilterElementWithNamespace(sNamespaceURI));
    }

    @Nonnull
    public static IIterableIterator<Element> getChildElementIteratorNS(@Nonnull Node aStartNode, @Nullable String sNamespaceURI, @Nonnull @Nonempty String sLocalName) {
        if (StringHelper.hasNoText(sLocalName)) {
            throw new IllegalArgumentException("Passed local name is illegal");
        }
        return new ChildElementIterator(aStartNode, new FilterElementWithNamespaceAndLocalName(sNamespaceURI, sLocalName));
    }

    public static boolean hasNamespaceURI(@Nullable Node aNode, @Nullable String sNamespaceURI) {
        String sNSURI = aNode == null ? null : aNode.getNamespaceURI();
        return sNSURI != null && sNSURI.equals(sNamespaceURI);
    }

    @Nonnull
    public static String getPathToNode(@Nonnull Node aNode) {
        return XMLHelper.getPathToNode(aNode, "/");
    }

    @Nonnull
    @SuppressFBWarnings(value={"IL_INFINITE_LOOP"})
    public static String getPathToNode(@Nonnull Node aNode, @Nonnull String sSep) {
        if (aNode == null) {
            throw new NullPointerException("node");
        }
        if (sSep == null) {
            throw new NullPointerException("separator");
        }
        StringBuilder aRet = new StringBuilder();
        for (Node aCurNode = aNode; aCurNode != null; aCurNode = aCurNode.getParentNode()) {
            StringBuilder aName = new StringBuilder(aCurNode.getNodeName());
            if (aCurNode.getNodeType() == 1 && aCurNode.getParentNode() != null) {
                Element x;
                Element aCurElement = (Element)aCurNode;
                int nIndex = 0;
                Iterator i$ = XMLHelper.getChildElementIteratorNoNS(aCurNode.getParentNode()).iterator();
                while (i$.hasNext() && (x = (Element)i$.next()) != aCurNode) {
                    if (!x.getTagName().equals(aCurElement.getTagName())) continue;
                    ++nIndex;
                }
                aName.append('[').append(nIndex).append(']');
            }
            aRet.insert(0, sSep).insert(0, aName);
        }
        return aRet.toString();
    }

    public static void removeAllChildElements(@Nonnull Element aElement) {
        while (aElement.getChildNodes().getLength() > 0) {
            aElement.removeChild(aElement.getChildNodes().item(0));
        }
    }

    @Nonnull
    public static char[] getMaskedXMLText(@Nonnull EXMLVersion eXMLVersion, @Nonnull EXMLIncorrectCharacterHandling eIncorrectCharHandling, @Nullable String s) {
        char[] aChars;
        if (eIncorrectCharHandling.isTestRequired() && s != null && XMLHelper.containsInvalidXMLCharacter(aChars = s.toCharArray())) {
            eIncorrectCharHandling.notifyOnInvalidXMLCharacter(s, XMLHelper.getAllInvalidXMLCharacters(aChars));
            if (eIncorrectCharHandling.isReplaceWithNothing()) {
                return StringHelper.replaceMultiple(s, MASK_PATTERNS_ALL, MASK_REPLACE_ALL_EMPTY);
            }
        }
        if (eXMLVersion.equals((Object)EXMLVersion.XML_10)) {
            return StringHelper.replaceMultiple(s, MASK_PATTERNS_XML10, MASK_REPLACE_XML10);
        }
        return StringHelper.replaceMultiple(s, MASK_PATTERNS_ALL, MASK_REPLACE_ALL_XML11);
    }

    @Nonnegative
    public static int getMaskedXMLTextLength(@Nonnull EXMLVersion eXMLVersion, @Nonnull EXMLIncorrectCharacterHandling eIncorrectCharHandling, @Nullable String s) {
        if (StringHelper.hasNoText(s)) {
            return 0;
        }
        char[] aChars = s.toCharArray();
        if (eIncorrectCharHandling.isTestRequired() && XMLHelper.containsInvalidXMLCharacter(aChars)) {
            eIncorrectCharHandling.notifyOnInvalidXMLCharacter(s, XMLHelper.getAllInvalidXMLCharacters(aChars));
            if (eIncorrectCharHandling.isReplaceWithNothing()) {
                int nResLen = StringHelper.getReplaceMultipleResultLength(aChars, MASK_PATTERNS_ALL, MASK_REPLACE_ALL_EMPTY);
                return nResLen == -1 ? s.length() : nResLen;
            }
        }
        int nResLen = eXMLVersion.equals((Object)EXMLVersion.XML_10) ? StringHelper.getReplaceMultipleResultLength(aChars, MASK_PATTERNS_XML10, MASK_REPLACE_XML10) : StringHelper.getReplaceMultipleResultLength(aChars, MASK_PATTERNS_ALL, MASK_REPLACE_ALL_XML11);
        return nResLen == -1 ? s.length() : nResLen;
    }

    public static void maskXMLTextTo(@Nonnull EXMLVersion eXMLVersion, @Nonnull EXMLIncorrectCharacterHandling eIncorrectCharHandling, @Nullable String sText, @Nonnull Writer aWriter) throws IOException {
        char[] aChars;
        if (eIncorrectCharHandling.isTestRequired() && sText != null && XMLHelper.containsInvalidXMLCharacter(aChars = sText.toCharArray())) {
            eIncorrectCharHandling.notifyOnInvalidXMLCharacter(sText, XMLHelper.getAllInvalidXMLCharacters(aChars));
            if (eIncorrectCharHandling.isReplaceWithNothing()) {
                StringHelper.replaceMultipleTo(sText, MASK_PATTERNS_ALL, MASK_REPLACE_ALL_EMPTY, aWriter);
                return;
            }
        }
        if (eXMLVersion.equals((Object)EXMLVersion.XML_10)) {
            StringHelper.replaceMultipleTo(sText, MASK_PATTERNS_XML10, MASK_REPLACE_XML10, aWriter);
        } else {
            StringHelper.replaceMultipleTo(sText, MASK_PATTERNS_ALL, MASK_REPLACE_ALL_XML11, aWriter);
        }
    }

    public static boolean isTextNode(@Nullable Node aNode) {
        return aNode instanceof CharacterData && !(aNode instanceof Comment) || aNode instanceof EntityReference;
    }

    @Nullable
    public static String getFirstChildText(@Nullable Node aStartNode) {
        if (aStartNode != null) {
            NodeList aNodeList = aStartNode.getChildNodes();
            int nLen = aNodeList.getLength();
            for (int i = 0; i < nLen; ++i) {
                Text aText;
                Node aNode = aNodeList.item(i);
                if (!(aNode instanceof Text) || (aText = (Text)aNode).isElementContentWhitespace()) continue;
                return aText.getData();
            }
        }
        return null;
    }

    @Nullable
    public static String getAttributeValue(@Nonnull Element aElement, @Nonnull String sAttrName) {
        return XMLHelper.getAttributeValue(aElement, sAttrName, null);
    }

    @Nullable
    public static String getAttributeValue(@Nonnull Element aElement, @Nonnull String sAttrName, @Nullable String sDefault) {
        Attr aAttr = aElement.getAttributeNode(sAttrName);
        return aAttr == null ? sDefault : aAttr.getValue();
    }

    @Nullable
    public static Map<String, String> getAllAttributesAsMap(@Nullable Element aSrcNode) {
        NamedNodeMap aNNM;
        if (aSrcNode != null && (aNNM = aSrcNode.getAttributes()) != null) {
            LinkedHashMap<String, String> aMap = new LinkedHashMap<String, String>(aNNM.getLength());
            int nMax = aNNM.getLength();
            for (int i = 0; i < nMax; ++i) {
                Attr aAttr = (Attr)aNNM.item(i);
                aMap.put(aAttr.getName(), aAttr.getValue());
            }
            return aMap;
        }
        return null;
    }

    @Nonnull
    public static String getXMLNSPrefix(@Nonnull String sPrefix) {
        if (StringHelper.hasNoText(sPrefix) || sPrefix.contains(CXML.XML_PREFIX_NAMESPACE_SEP_STR)) {
            throw new IllegalArgumentException("prefix is invalid: " + sPrefix);
        }
        return "xmlns:" + sPrefix;
    }

    @Nullable
    public static String getNamespaceURI(@Nullable Node aNode) {
        if (aNode instanceof Document) {
            return XMLHelper.getNamespaceURI(((Document)aNode).getDocumentElement());
        }
        if (aNode != null) {
            return aNode.getNamespaceURI();
        }
        return null;
    }

    public static boolean isInvalidXMLCharacter(char c) {
        if (c < '\u0100') {
            return ILLEGAL_XML_CHARS[c];
        }
        return c == '\u2028' || c >= '\ufdd0' && c <= '\ufddf' || c == '\ufffe' || c == '\uffff' || Character.isHighSurrogate(c) || Character.isLowSurrogate(c);
    }

    public static boolean containsInvalidXMLCharacter(@Nullable String s) {
        return s == null ? false : XMLHelper.containsInvalidXMLCharacter(s.toCharArray());
    }

    public static boolean containsInvalidXMLCharacter(@Nullable char[] aChars) {
        if (aChars != null) {
            for (char c : aChars) {
                if (!XMLHelper.isInvalidXMLCharacter(c)) continue;
                return true;
            }
        }
        return false;
    }

    @Nullable
    public static Set<Character> getAllInvalidXMLCharacters(@Nullable String s) {
        return s == null ? null : XMLHelper.getAllInvalidXMLCharacters(s.toCharArray());
    }

    @Nullable
    public static Set<Character> getAllInvalidXMLCharacters(@Nullable char[] aChars) {
        if (ArrayHelper.isEmpty(aChars)) {
            return null;
        }
        HashSet<Character> aRes = new HashSet<Character>();
        for (char c : aChars) {
            if (!XMLHelper.isInvalidXMLCharacter(c)) continue;
            aRes.add(Character.valueOf(c));
        }
        return aRes;
    }

    @Nonnegative
    public static int getLength(@Nullable NodeList aNL) {
        return aNL == null ? 0 : aNL.getLength();
    }

    public static boolean isEmpty(@Nullable NodeList aNL) {
        return XMLHelper.getLength(aNL) == 0;
    }

    static {
        if (MASK_PATTERNS_XML10.length != MASK_REPLACE_XML10.length) {
            throw new IllegalStateException("Regular arrays have different length!");
        }
        if (MASK_PATTERNS_CONTROL.length != MASK_REPLACE_CONTROL_EMPTY.length) {
            throw new IllegalStateException("Empty arrays have different length!");
        }
        if (MASK_PATTERNS_CONTROL.length != MASK_REPLACE_CONTROL_XML11.length) {
            throw new IllegalStateException("Control arrays have different length!");
        }
        if (MASK_PATTERNS_ALL.length != MASK_REPLACE_ALL_EMPTY.length) {
            throw new IllegalStateException("Empty arrays have different length!");
        }
        if (MASK_PATTERNS_ALL.length != MASK_REPLACE_ALL_XML11.length) {
            throw new IllegalStateException("Overall arrays have different length!");
        }
        s_aInstance = new XMLHelper();
    }
}

