/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.typeconvert.impl;

import com.phloc.commons.annotations.IsSPIImplementation;
import com.phloc.commons.base64.Base64;
import com.phloc.commons.base64.Base64Helper;
import com.phloc.commons.collections.ContainerHelper;
import com.phloc.commons.typeconvert.ITypeConverter;
import com.phloc.commons.typeconvert.ITypeConverterRegistrarSPI;
import com.phloc.commons.typeconvert.ITypeConverterRegistry;
import com.phloc.commons.typeconvert.rule.AbstractTypeConverterRuleAnySourceFixedDestination;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
@IsSPIImplementation
public final class CollectionTypeConverterRegistrar
implements ITypeConverterRegistrarSPI {
    @Override
    public void registerTypeConverter(@Nonnull ITypeConverterRegistry aRegistry) {
        aRegistry.registerTypeConverterRule(new AbstractTypeConverterRuleAnySourceFixedDestination(ArrayList.class){

            @Override
            public ArrayList<?> convert(@Nonnull Object aSource) {
                if (aSource instanceof Collection) {
                    return new ArrayList((Collection)aSource);
                }
                ArrayList<Object> ret = new ArrayList<Object>(1);
                ret.add(aSource);
                return ret;
            }
        });
        aRegistry.registerTypeConverterRule(new AbstractTypeConverterRuleAnySourceFixedDestination(Vector.class){

            @Override
            public Vector<?> convert(@Nonnull Object aSource) {
                if (aSource instanceof Collection) {
                    return new Vector((Collection)aSource);
                }
                Vector<Object> ret = new Vector<Object>(1);
                ret.add(aSource);
                return ret;
            }
        });
        aRegistry.registerTypeConverterRule(new AbstractTypeConverterRuleAnySourceFixedDestination(LinkedList.class){

            @Override
            public LinkedList<?> convert(@Nonnull Object aSource) {
                if (aSource instanceof Collection) {
                    return new LinkedList((Collection)aSource);
                }
                LinkedList<Object> ret = new LinkedList<Object>();
                ret.add(aSource);
                return ret;
            }
        });
        aRegistry.registerTypeConverterRule(new AbstractTypeConverterRuleAnySourceFixedDestination(CopyOnWriteArrayList.class){

            @Override
            public CopyOnWriteArrayList<?> convert(@Nonnull Object aSource) {
                if (aSource instanceof Collection) {
                    return new CopyOnWriteArrayList((Collection)aSource);
                }
                CopyOnWriteArrayList<Object> ret = new CopyOnWriteArrayList<Object>();
                ret.add(aSource);
                return ret;
            }
        });
        aRegistry.registerTypeConverterRule(new AbstractTypeConverterRuleAnySourceFixedDestination(List.class){

            @Override
            public List<?> convert(@Nonnull Object aSource) {
                if (aSource instanceof Collection) {
                    return ContainerHelper.newList((Collection)aSource);
                }
                return ContainerHelper.newList(aSource);
            }
        });
        aRegistry.registerTypeConverterRule(new AbstractTypeConverterRuleAnySourceFixedDestination(TreeSet.class){

            @Override
            public TreeSet<?> convert(@Nonnull Object aSource) {
                if (aSource instanceof Collection) {
                    return new TreeSet((Collection)aSource);
                }
                TreeSet<Object> ret = new TreeSet<Object>();
                ret.add(aSource);
                return ret;
            }
        });
        aRegistry.registerTypeConverterRule(new AbstractTypeConverterRuleAnySourceFixedDestination(LinkedHashSet.class){

            @Override
            public LinkedHashSet<?> convert(@Nonnull Object aSource) {
                if (aSource instanceof Collection) {
                    return new LinkedHashSet((Collection)aSource);
                }
                LinkedHashSet<Object> ret = new LinkedHashSet<Object>(1);
                ret.add(aSource);
                return ret;
            }
        });
        aRegistry.registerTypeConverterRule(new AbstractTypeConverterRuleAnySourceFixedDestination(CopyOnWriteArraySet.class){

            @Override
            public CopyOnWriteArraySet<?> convert(@Nonnull Object aSource) {
                if (aSource instanceof Collection) {
                    return new CopyOnWriteArraySet((Collection)aSource);
                }
                CopyOnWriteArraySet<Object> ret = new CopyOnWriteArraySet<Object>();
                ret.add(aSource);
                return ret;
            }
        });
        aRegistry.registerTypeConverterRule(new AbstractTypeConverterRuleAnySourceFixedDestination(Set.class){

            @Override
            public Set<?> convert(@Nonnull Object aSource) {
                if (aSource instanceof Collection) {
                    return ContainerHelper.newSet((Collection)aSource);
                }
                return ContainerHelper.newSet(aSource);
            }
        });
        aRegistry.registerTypeConverter(boolean[].class, ArrayList.class, new ITypeConverter(){

            @Override
            public List<Boolean> convert(@Nonnull Object aSource) {
                return ContainerHelper.newBooleanList((boolean[])aSource);
            }
        });
        aRegistry.registerTypeConverter(boolean[].class, Vector.class, new ITypeConverter(){

            @Override
            public Vector<Boolean> convert(@Nonnull Object aSource) {
                return ContainerHelper.newBooleanVector((boolean[])aSource);
            }
        });
        aRegistry.registerTypeConverter(boolean[].class, HashSet.class, new ITypeConverter(){

            @Override
            public Set<Boolean> convert(@Nonnull Object aSource) {
                return ContainerHelper.newBooleanSet((boolean[])aSource);
            }
        });
        aRegistry.registerTypeConverter(boolean[].class, LinkedHashSet.class, new ITypeConverter(){

            @Override
            public Set<Boolean> convert(@Nonnull Object aSource) {
                return ContainerHelper.newBooleanOrderedSet((boolean[])aSource);
            }
        });
        aRegistry.registerTypeConverter(boolean[].class, TreeSet.class, new ITypeConverter(){

            @Override
            public Set<Boolean> convert(@Nonnull Object aSource) {
                return ContainerHelper.newBooleanSortedSet((boolean[])aSource);
            }
        });
        aRegistry.registerTypeConverter(byte[].class, String.class, new ITypeConverter(){

            @Override
            public String convert(@Nonnull Object aSource) {
                return Base64.encodeBytes((byte[])aSource);
            }
        });
        aRegistry.registerTypeConverter(String.class, byte[].class, new ITypeConverter(){

            @Override
            public byte[] convert(@Nonnull Object aSource) {
                return Base64Helper.safeDecode((String)aSource);
            }
        });
        aRegistry.registerTypeConverter(byte[].class, ArrayList.class, new ITypeConverter(){

            @Override
            public List<Byte> convert(@Nonnull Object aSource) {
                return ContainerHelper.newByteList((byte[])aSource);
            }
        });
        aRegistry.registerTypeConverter(byte[].class, Vector.class, new ITypeConverter(){

            @Override
            public Vector<Byte> convert(@Nonnull Object aSource) {
                return ContainerHelper.newByteVector((byte[])aSource);
            }
        });
        aRegistry.registerTypeConverter(byte[].class, HashSet.class, new ITypeConverter(){

            @Override
            public Set<Byte> convert(@Nonnull Object aSource) {
                return ContainerHelper.newByteSet((byte[])aSource);
            }
        });
        aRegistry.registerTypeConverter(byte[].class, LinkedHashSet.class, new ITypeConverter(){

            @Override
            public Set<Byte> convert(@Nonnull Object aSource) {
                return ContainerHelper.newByteOrderedSet((byte[])aSource);
            }
        });
        aRegistry.registerTypeConverter(byte[].class, TreeSet.class, new ITypeConverter(){

            @Override
            public Set<Byte> convert(@Nonnull Object aSource) {
                return ContainerHelper.newByteSortedSet((byte[])aSource);
            }
        });
        aRegistry.registerTypeConverter(char[].class, String.class, new ITypeConverter(){

            @Override
            public String convert(@Nonnull Object aSource) {
                return new String((char[])aSource);
            }
        });
        aRegistry.registerTypeConverter(String.class, char[].class, new ITypeConverter(){

            @Override
            public char[] convert(@Nonnull Object aSource) {
                return ((String)aSource).toCharArray();
            }
        });
        aRegistry.registerTypeConverter(char[].class, ArrayList.class, new ITypeConverter(){

            @Override
            public List<Character> convert(@Nonnull Object aSource) {
                return ContainerHelper.newCharList((char[])aSource);
            }
        });
        aRegistry.registerTypeConverter(char[].class, Vector.class, new ITypeConverter(){

            @Override
            public Vector<Character> convert(@Nonnull Object aSource) {
                return ContainerHelper.newCharVector((char[])aSource);
            }
        });
        aRegistry.registerTypeConverter(char[].class, HashSet.class, new ITypeConverter(){

            @Override
            public Set<Character> convert(@Nonnull Object aSource) {
                return ContainerHelper.newCharSet((char[])aSource);
            }
        });
        aRegistry.registerTypeConverter(char[].class, LinkedHashSet.class, new ITypeConverter(){

            @Override
            public Set<Character> convert(@Nonnull Object aSource) {
                return ContainerHelper.newCharOrderedSet((char[])aSource);
            }
        });
        aRegistry.registerTypeConverter(char[].class, TreeSet.class, new ITypeConverter(){

            @Override
            public Set<Character> convert(@Nonnull Object aSource) {
                return ContainerHelper.newCharSortedSet((char[])aSource);
            }
        });
        aRegistry.registerTypeConverter(double[].class, ArrayList.class, new ITypeConverter(){

            @Override
            public List<Double> convert(@Nonnull Object aSource) {
                return ContainerHelper.newDoubleList((double[])aSource);
            }
        });
        aRegistry.registerTypeConverter(double[].class, Vector.class, new ITypeConverter(){

            @Override
            public Vector<Double> convert(@Nonnull Object aSource) {
                return ContainerHelper.newDoubleVector((double[])aSource);
            }
        });
        aRegistry.registerTypeConverter(double[].class, HashSet.class, new ITypeConverter(){

            @Override
            public Set<Double> convert(@Nonnull Object aSource) {
                return ContainerHelper.newDoubleSet((double[])aSource);
            }
        });
        aRegistry.registerTypeConverter(double[].class, LinkedHashSet.class, new ITypeConverter(){

            @Override
            public Set<Double> convert(@Nonnull Object aSource) {
                return ContainerHelper.newDoubleOrderedSet((double[])aSource);
            }
        });
        aRegistry.registerTypeConverter(double[].class, TreeSet.class, new ITypeConverter(){

            @Override
            public Set<Double> convert(@Nonnull Object aSource) {
                return ContainerHelper.newDoubleSortedSet((double[])aSource);
            }
        });
        aRegistry.registerTypeConverter(float[].class, ArrayList.class, new ITypeConverter(){

            @Override
            public List<Float> convert(@Nonnull Object aSource) {
                return ContainerHelper.newFloatList((float[])aSource);
            }
        });
        aRegistry.registerTypeConverter(float[].class, Vector.class, new ITypeConverter(){

            @Override
            public Vector<Float> convert(@Nonnull Object aSource) {
                return ContainerHelper.newFloatVector((float[])aSource);
            }
        });
        aRegistry.registerTypeConverter(float[].class, HashSet.class, new ITypeConverter(){

            @Override
            public Set<Float> convert(@Nonnull Object aSource) {
                return ContainerHelper.newFloatSet((float[])aSource);
            }
        });
        aRegistry.registerTypeConverter(float[].class, LinkedHashSet.class, new ITypeConverter(){

            @Override
            public Set<Float> convert(@Nonnull Object aSource) {
                return ContainerHelper.newFloatOrderedSet((float[])aSource);
            }
        });
        aRegistry.registerTypeConverter(float[].class, TreeSet.class, new ITypeConverter(){

            @Override
            public Set<Float> convert(@Nonnull Object aSource) {
                return ContainerHelper.newFloatSortedSet((float[])aSource);
            }
        });
        aRegistry.registerTypeConverter(int[].class, ArrayList.class, new ITypeConverter(){

            @Override
            public List<Integer> convert(@Nonnull Object aSource) {
                return ContainerHelper.newIntList((int[])aSource);
            }
        });
        aRegistry.registerTypeConverter(int[].class, Vector.class, new ITypeConverter(){

            @Override
            public Vector<Integer> convert(@Nonnull Object aSource) {
                return ContainerHelper.newIntVector((int[])aSource);
            }
        });
        aRegistry.registerTypeConverter(int[].class, HashSet.class, new ITypeConverter(){

            @Override
            public Set<Integer> convert(@Nonnull Object aSource) {
                return ContainerHelper.newIntSet((int[])aSource);
            }
        });
        aRegistry.registerTypeConverter(int[].class, LinkedHashSet.class, new ITypeConverter(){

            @Override
            public Set<Integer> convert(@Nonnull Object aSource) {
                return ContainerHelper.newIntOrderedSet((int[])aSource);
            }
        });
        aRegistry.registerTypeConverter(int[].class, TreeSet.class, new ITypeConverter(){

            @Override
            public Set<Integer> convert(@Nonnull Object aSource) {
                return ContainerHelper.newIntSortedSet((int[])aSource);
            }
        });
        aRegistry.registerTypeConverter(long[].class, ArrayList.class, new ITypeConverter(){

            @Override
            public List<Long> convert(@Nonnull Object aSource) {
                return ContainerHelper.newLongList((long[])aSource);
            }
        });
        aRegistry.registerTypeConverter(long[].class, Vector.class, new ITypeConverter(){

            @Override
            public Vector<Long> convert(@Nonnull Object aSource) {
                return ContainerHelper.newLongVector((long[])aSource);
            }
        });
        aRegistry.registerTypeConverter(long[].class, HashSet.class, new ITypeConverter(){

            @Override
            public Set<Long> convert(@Nonnull Object aSource) {
                return ContainerHelper.newLongSet((long[])aSource);
            }
        });
        aRegistry.registerTypeConverter(long[].class, LinkedHashSet.class, new ITypeConverter(){

            @Override
            public Set<Long> convert(@Nonnull Object aSource) {
                return ContainerHelper.newLongOrderedSet((long[])aSource);
            }
        });
        aRegistry.registerTypeConverter(long[].class, TreeSet.class, new ITypeConverter(){

            @Override
            public Set<Long> convert(@Nonnull Object aSource) {
                return ContainerHelper.newLongSortedSet((long[])aSource);
            }
        });
        aRegistry.registerTypeConverter(short[].class, ArrayList.class, new ITypeConverter(){

            @Override
            public List<Short> convert(@Nonnull Object aSource) {
                return ContainerHelper.newShortList((short[])aSource);
            }
        });
        aRegistry.registerTypeConverter(short[].class, Vector.class, new ITypeConverter(){

            @Override
            public Vector<Short> convert(@Nonnull Object aSource) {
                return ContainerHelper.newShortVector((short[])aSource);
            }
        });
        aRegistry.registerTypeConverter(short[].class, HashSet.class, new ITypeConverter(){

            @Override
            public Set<Short> convert(@Nonnull Object aSource) {
                return ContainerHelper.newShortSet((short[])aSource);
            }
        });
        aRegistry.registerTypeConverter(short[].class, LinkedHashSet.class, new ITypeConverter(){

            @Override
            public Set<Short> convert(@Nonnull Object aSource) {
                return ContainerHelper.newShortOrderedSet((short[])aSource);
            }
        });
        aRegistry.registerTypeConverter(short[].class, TreeSet.class, new ITypeConverter(){

            @Override
            public Set<Short> convert(@Nonnull Object aSource) {
                return ContainerHelper.newShortSortedSet((short[])aSource);
            }
        });
    }
}

