/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.text.resolve;

import com.phloc.commons.lang.EnumHelper;
import com.phloc.commons.stats.IStatisticsHandlerCounter;
import com.phloc.commons.stats.IStatisticsHandlerKeyedCounter;
import com.phloc.commons.stats.StatisticsManager;
import com.phloc.commons.text.ITextProvider;
import com.phloc.commons.text.impl.TextFormatter;
import com.phloc.commons.text.resolve.IEnumTextResolver;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public abstract class AbstractEnumTextResolverWithOverrideAndFallback
implements IEnumTextResolver {
    private static final IStatisticsHandlerKeyedCounter s_aStatsGetText = StatisticsManager.getKeyedCounterHandler(AbstractEnumTextResolverWithOverrideAndFallback.class.getName() + "$getText");
    private static final IStatisticsHandlerKeyedCounter s_aStatsGetTextWithArgs = StatisticsManager.getKeyedCounterHandler(AbstractEnumTextResolverWithOverrideAndFallback.class.getName() + "$getTextWithArgs");
    private static final IStatisticsHandlerCounter s_aStatsOverride = StatisticsManager.getCounterHandler(AbstractEnumTextResolverWithOverrideAndFallback.class.getName() + "$OVERRIDE");
    private static final IStatisticsHandlerCounter s_aStatsFallback = StatisticsManager.getCounterHandler(AbstractEnumTextResolverWithOverrideAndFallback.class.getName() + "$FALLBACK");

    @Nullable
    protected abstract String internalGetOverrideString(@Nonnull String var1, @Nonnull Locale var2);

    @Nullable
    protected abstract String internalGetFallbackString(@Nonnull String var1, @Nonnull Locale var2);

    @Nullable
    private String _getText(@Nonnull Enum<?> aEnum, @Nonnull ITextProvider aTP, @Nonnull Locale aContentLocale, boolean bIsWithArgs) {
        String sID = EnumHelper.getEnumID(aEnum);
        (bIsWithArgs ? s_aStatsGetTextWithArgs : s_aStatsGetText).increment(sID);
        String ret = this.internalGetOverrideString(sID, aContentLocale);
        if (ret != null) {
            s_aStatsOverride.increment();
        } else {
            ret = aTP.getTextWithLocaleFallback(aContentLocale);
            if (ret == null) {
                s_aStatsFallback.increment();
                ret = this.internalGetFallbackString(sID, aContentLocale);
            }
        }
        return ret;
    }

    @Override
    @Nullable
    public final String getText(@Nonnull Enum<?> aEnum, @Nonnull ITextProvider aTP, @Nonnull Locale aContentLocale) {
        return this._getText(aEnum, aTP, aContentLocale, false);
    }

    @Override
    @Nullable
    public final String getTextWithArgs(@Nonnull Enum<?> aEnum, @Nonnull ITextProvider aTP, @Nonnull Locale aContentLocale, Object ... aArgs) {
        String sText = this._getText(aEnum, aTP, aContentLocale, true);
        return TextFormatter.getFormattedText(sText, aArgs);
    }
}

