/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.string;

import com.phloc.commons.string.StringHelper;
import java.util.Arrays;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class ToStringGenerator {
    public static final String CONSTANT_NULL = "null";
    public static final String CONSTANT_THIS = "this";
    public static final String CONSTANT_PASSWORD = "****";
    private static final int FIRST_FIELD = 1;
    private static final int APPENDED_CLOSING_BRACKET = 2;
    private final StringBuilder m_aSB = new StringBuilder("[");
    private final Object m_aSrc;
    private int m_nIndex = 0;

    public ToStringGenerator(@Nullable Object aSrc) {
        if (aSrc != null) {
            String sClassName = aSrc.getClass().getName();
            int nIndex = sClassName.lastIndexOf(46);
            this.m_aSB.append(nIndex == -1 ? sClassName : sClassName.substring(nIndex + 1)).append("@0x").append(StringHelper.getHexStringLeadingZero(System.identityHashCode(aSrc), 8));
        }
        this.m_aSrc = aSrc;
    }

    private void _beforeAddField() {
        if ((this.m_nIndex & 1) == 0) {
            this.m_nIndex |= 1;
            if (this.m_aSB.length() > 1) {
                this.m_aSB.append(": ");
            }
        } else {
            this.m_aSB.append("; ");
        }
    }

    @Nonnull
    private ToStringGenerator _appendSuper(String sSuper) {
        this._beforeAddField();
        this.m_aSB.append(sSuper);
        return this;
    }

    @Nonnull
    public ToStringGenerator append(@Nonnull String sField, boolean aValue) {
        this._beforeAddField();
        this.m_aSB.append(sField).append('=').append(aValue);
        return this;
    }

    @Nonnull
    public ToStringGenerator append(@Nonnull String sField, @Nullable boolean[] aValue) {
        this._beforeAddField();
        this.m_aSB.append(sField).append('=').append(Arrays.toString(aValue));
        return this;
    }

    @Nonnull
    public ToStringGenerator append(@Nonnull String sField, byte aValue) {
        this._beforeAddField();
        this.m_aSB.append(sField).append('=').append(aValue);
        return this;
    }

    @Nonnull
    public ToStringGenerator append(@Nonnull String sField, @Nullable byte[] aValue) {
        this._beforeAddField();
        this.m_aSB.append(sField).append('=').append(Arrays.toString(aValue));
        return this;
    }

    @Nonnull
    public ToStringGenerator append(@Nonnull String sField, char aValue) {
        this._beforeAddField();
        this.m_aSB.append(sField).append('=').append(aValue);
        return this;
    }

    @Nonnull
    public ToStringGenerator append(@Nonnull String sField, @Nullable char[] aValue) {
        this._beforeAddField();
        this.m_aSB.append(sField).append('=').append(Arrays.toString(aValue));
        return this;
    }

    @Nonnull
    public ToStringGenerator append(@Nonnull String sField, double aValue) {
        this._beforeAddField();
        this.m_aSB.append(sField).append('=').append(aValue);
        return this;
    }

    @Nonnull
    public ToStringGenerator append(@Nonnull String sField, @Nullable double[] aValue) {
        this._beforeAddField();
        this.m_aSB.append(sField).append('=').append(Arrays.toString(aValue));
        return this;
    }

    @Nonnull
    public ToStringGenerator append(@Nonnull String sField, float aValue) {
        this._beforeAddField();
        this.m_aSB.append(sField).append('=').append(aValue);
        return this;
    }

    @Nonnull
    public ToStringGenerator append(@Nonnull String sField, @Nullable float[] aValue) {
        this._beforeAddField();
        this.m_aSB.append(sField).append('=').append(Arrays.toString(aValue));
        return this;
    }

    @Nonnull
    public ToStringGenerator append(@Nonnull String sField, int aValue) {
        this._beforeAddField();
        this.m_aSB.append(sField).append('=').append(aValue);
        return this;
    }

    @Nonnull
    public ToStringGenerator append(@Nonnull String sField, @Nullable int[] aValue) {
        this._beforeAddField();
        this.m_aSB.append(sField).append('=').append(Arrays.toString(aValue));
        return this;
    }

    @Nonnull
    public ToStringGenerator append(@Nonnull String sField, long aValue) {
        this._beforeAddField();
        this.m_aSB.append(sField).append('=').append(aValue);
        return this;
    }

    @Nonnull
    public ToStringGenerator append(@Nonnull String sField, @Nullable long[] aValue) {
        this._beforeAddField();
        this.m_aSB.append(sField).append('=').append(Arrays.toString(aValue));
        return this;
    }

    @Nonnull
    public ToStringGenerator append(@Nonnull String sField, short aValue) {
        this._beforeAddField();
        this.m_aSB.append(sField).append('=').append(aValue);
        return this;
    }

    @Nonnull
    public ToStringGenerator append(@Nonnull String sField, @Nullable short[] aValue) {
        this._beforeAddField();
        this.m_aSB.append(sField).append('=').append(Arrays.toString(aValue));
        return this;
    }

    @Nonnull
    public ToStringGenerator appendPassword(@Nonnull String sField) {
        return this.append(sField, CONSTANT_PASSWORD);
    }

    @Nonnull
    public ToStringGenerator append(@Nonnull String sField, @Nullable Enum<?> aValue) {
        return this.append(sField, String.valueOf(aValue));
    }

    @Nonnull
    private String _getObjectValue(@Nullable Object aValue) {
        return aValue == null ? CONSTANT_NULL : (aValue == this.m_aSrc ? CONSTANT_THIS : aValue.toString());
    }

    @Nonnull
    public ToStringGenerator append(@Nonnull String sField, @Nullable Object aValue) {
        if (aValue != null && aValue.getClass().isArray()) {
            Class<?> aCompType = aValue.getClass().getComponentType();
            if (aCompType.equals(Boolean.TYPE)) {
                return this.append(sField, (boolean[])aValue);
            }
            if (aCompType.equals(Byte.TYPE)) {
                return this.append(sField, (byte[])aValue);
            }
            if (aCompType.equals(Character.TYPE)) {
                return this.append(sField, (char[])aValue);
            }
            if (aCompType.equals(Double.TYPE)) {
                return this.append(sField, (double[])aValue);
            }
            if (aCompType.equals(Float.TYPE)) {
                return this.append(sField, (float[])aValue);
            }
            if (aCompType.equals(Integer.TYPE)) {
                return this.append(sField, (int[])aValue);
            }
            if (aCompType.equals(Long.TYPE)) {
                return this.append(sField, (long[])aValue);
            }
            if (aCompType.equals(Short.TYPE)) {
                return this.append(sField, (short[])aValue);
            }
            return this.append(sField, (Object[])aValue);
        }
        this._beforeAddField();
        this.m_aSB.append(sField).append('=').append(this._getObjectValue(aValue));
        return this;
    }

    @Nonnull
    public ToStringGenerator append(@Nonnull String sField, @Nullable Object[] aValue) {
        this._beforeAddField();
        this.m_aSB.append(sField).append('=');
        if (aValue == null) {
            this.m_aSB.append(CONSTANT_NULL);
        } else {
            int nMax = aValue.length - 1;
            if (nMax == -1) {
                this.m_aSB.append("[]");
            } else {
                this.m_aSB.append('[');
                int i = 0;
                while (true) {
                    this.m_aSB.append(this._getObjectValue(aValue[i]));
                    if (i == nMax) break;
                    this.m_aSB.append(", ");
                    ++i;
                }
                this.m_aSB.append(']');
            }
        }
        return this;
    }

    @Nonnull
    public ToStringGenerator appendIfNotNull(@Nonnull String sField, @Nullable boolean[] aValue) {
        return aValue == null ? this : this.append(sField, aValue);
    }

    @Nonnull
    public ToStringGenerator appendIfNotNull(@Nonnull String sField, @Nullable byte[] aValue) {
        return aValue == null ? this : this.append(sField, aValue);
    }

    @Nonnull
    public ToStringGenerator appendIfNotNull(@Nonnull String sField, @Nullable char[] aValue) {
        return aValue == null ? this : this.append(sField, aValue);
    }

    @Nonnull
    public ToStringGenerator appendIfNotNull(@Nonnull String sField, @Nullable double[] aValue) {
        return aValue == null ? this : this.append(sField, aValue);
    }

    @Nonnull
    public ToStringGenerator appendIfNotNull(@Nonnull String sField, @Nullable float[] aValue) {
        return aValue == null ? this : this.append(sField, aValue);
    }

    @Nonnull
    public ToStringGenerator appendIfNotNull(@Nonnull String sField, @Nullable int[] aValue) {
        return aValue == null ? this : this.append(sField, aValue);
    }

    @Nonnull
    public ToStringGenerator appendIfNotNull(@Nonnull String sField, @Nullable long[] aValue) {
        return aValue == null ? this : this.append(sField, aValue);
    }

    @Nonnull
    public ToStringGenerator appendIfNotNull(@Nonnull String sField, @Nullable short[] aValue) {
        return aValue == null ? this : this.append(sField, aValue);
    }

    @Nonnull
    public ToStringGenerator appendIfNotNull(@Nonnull String sField, @Nullable Object aValue) {
        return aValue == null ? this : this.append(sField, aValue);
    }

    @Nonnull
    public ToStringGenerator appendIfNotNull(@Nonnull String sField, @Nullable Object[] aValue) {
        return aValue == null ? this : this.append(sField, aValue);
    }

    @Nonnull
    public String toString() {
        if ((this.m_nIndex & 2) == 0) {
            this.m_nIndex |= 2;
            this.m_aSB.append(']');
        }
        return this.m_aSB.toString();
    }

    @Nonnull
    public static ToStringGenerator getDerived(@Nonnull String sSuperToString) {
        return new ToStringGenerator(null)._appendSuper(sSuperToString);
    }
}

