/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.string;

import com.phloc.commons.annotations.Nonempty;
import java.math.BigDecimal;
import java.math.BigInteger;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class StringParser {
    public static final int DEFAULT_RADIX = 10;
    private static final StringParser s_aInstance = new StringParser();

    protected StringParser() {
    }

    @Nonnull
    @Nonempty
    private static String _getUnifiedDecimal(@Nonnull @Nonempty String sStr) {
        return sStr.replace(',', '.');
    }

    public static boolean parseBool(@Nullable Object aObject) {
        return StringParser.parseBool(aObject, false);
    }

    public static boolean parseBool(@Nullable Object aObject, boolean bDefault) {
        if (aObject instanceof Boolean) {
            return (Boolean)aObject;
        }
        if (aObject instanceof String) {
            return StringParser.parseBool((String)aObject);
        }
        return bDefault;
    }

    public static boolean parseBool(@Nullable String sStr) {
        return Boolean.parseBoolean(sStr);
    }

    @Nullable
    public static Boolean parseBoolObj(@Nullable Object aObject) {
        return StringParser.parseBoolObj(aObject, null);
    }

    @Nullable
    public static Boolean parseBoolObj(@Nullable Object aObject, @Nullable Boolean aDefault) {
        return aObject == null ? aDefault : StringParser.parseBoolObj(aObject.toString());
    }

    @Nonnull
    public static Boolean parseBoolObj(@Nullable String sStr) {
        return Boolean.valueOf(sStr);
    }

    @Nullable
    public static Boolean parseBoolObjExact(@Nullable String sStr) {
        return StringParser.parseBoolObjExact(sStr, null);
    }

    @Nullable
    public static Boolean parseBoolObjExact(@Nullable String sStr, @Nullable Boolean aDefault) {
        if (Boolean.TRUE.toString().equalsIgnoreCase(sStr)) {
            return Boolean.TRUE;
        }
        if (Boolean.FALSE.toString().equalsIgnoreCase(sStr)) {
            return Boolean.FALSE;
        }
        return aDefault;
    }

    public static byte parseByte(@Nullable Object aObject, byte nDefault) {
        return StringParser.parseByte(aObject, 10, nDefault);
    }

    public static byte parseByte(@Nullable Object aObject, @Nonnegative int nRadix, byte nDefault) {
        if (aObject == null) {
            return nDefault;
        }
        if (aObject instanceof Number) {
            return ((Number)aObject).byteValue();
        }
        return StringParser.parseByte(aObject.toString(), nRadix, nDefault);
    }

    public static byte parseByte(@Nullable String sStr, byte nDefault) {
        return StringParser.parseByte(sStr, 10, nDefault);
    }

    public static byte parseByte(@Nullable String sStr, @Nonnegative int nRadix, byte nDefault) {
        if (sStr != null && sStr.length() > 0) {
            try {
                return Byte.parseByte(sStr, nRadix);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return nDefault;
    }

    @Nullable
    public static Byte parseByteObj(@Nullable Object aObject) {
        return StringParser.parseByteObj(aObject, 10, null);
    }

    @Nullable
    public static Byte parseByteObj(@Nullable Object aObject, @Nullable Byte aDefault) {
        return StringParser.parseByteObj(aObject, 10, aDefault);
    }

    @Nullable
    public static Byte parseByteObj(@Nullable Object aObject, @Nonnegative int nRadix, @Nullable Byte aDefault) {
        if (aObject == null) {
            return aDefault;
        }
        if (aObject instanceof Number) {
            return ((Number)aObject).byteValue();
        }
        return StringParser.parseByteObj(aObject.toString(), nRadix, aDefault);
    }

    @Nullable
    public static Byte parseByteObj(@Nullable String sStr) {
        return StringParser.parseByteObj(sStr, 10, null);
    }

    @Nullable
    public static Byte parseByteObj(@Nullable String sStr, @Nullable Byte aDefault) {
        return StringParser.parseByteObj(sStr, 10, aDefault);
    }

    @Nullable
    public static Byte parseByteObj(@Nullable String sStr, @Nonnegative int nRadix, @Nullable Byte aDefault) {
        if (sStr != null && sStr.length() > 0) {
            try {
                return Byte.valueOf(sStr, nRadix);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return aDefault;
    }

    public static double parseDouble(@Nullable Object aObject, double dDefault) {
        if (aObject == null) {
            return dDefault;
        }
        if (aObject instanceof Number) {
            return ((Number)aObject).doubleValue();
        }
        return StringParser.parseDouble(aObject.toString(), dDefault);
    }

    public static double parseDouble(@Nullable String sStr, double dDefault) {
        if (sStr != null && sStr.length() > 0) {
            try {
                return Double.parseDouble(StringParser._getUnifiedDecimal(sStr));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return dDefault;
    }

    @Nullable
    public static Double parseDoubleObj(@Nullable Object aObject) {
        return StringParser.parseDoubleObj(aObject, null);
    }

    @Nullable
    public static Double parseDoubleObj(@Nullable Object aObject, @Nullable Double aDefault) {
        double dValue = StringParser.parseDouble(aObject, Double.NaN);
        return Double.isNaN(dValue) ? aDefault : Double.valueOf(dValue);
    }

    @Nullable
    public static Double parseDoubleObj(@Nullable String sStr) {
        return StringParser.parseDoubleObj(sStr, null);
    }

    @Nullable
    public static Double parseDoubleObj(@Nullable String sStr, @Nullable Double aDefault) {
        double dValue = StringParser.parseDouble(sStr, Double.NaN);
        return Double.isNaN(dValue) ? aDefault : Double.valueOf(dValue);
    }

    public static float parseFloat(@Nullable Object aObject, float fDefault) {
        if (aObject == null) {
            return fDefault;
        }
        if (aObject instanceof Number) {
            return ((Number)aObject).floatValue();
        }
        return StringParser.parseFloat(aObject.toString(), fDefault);
    }

    public static float parseFloat(@Nullable String sStr, float fDefault) {
        if (sStr != null && sStr.length() > 0) {
            try {
                return Float.parseFloat(StringParser._getUnifiedDecimal(sStr));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return fDefault;
    }

    @Nullable
    public static Float parseFloatObj(@Nullable Object aObject) {
        return StringParser.parseFloatObj(aObject, null);
    }

    @Nullable
    public static Float parseFloatObj(@Nullable Object aObject, @Nullable Float aDefault) {
        float fValue = StringParser.parseFloat(aObject, Float.NaN);
        return Float.isNaN(fValue) ? aDefault : Float.valueOf(fValue);
    }

    @Nullable
    public static Float parseFloatObj(@Nullable String sStr) {
        return StringParser.parseFloatObj(sStr, null);
    }

    @Nullable
    public static Float parseFloatObj(@Nullable String sStr, @Nullable Float aDefault) {
        float fValue = StringParser.parseFloat(sStr, Float.NaN);
        return Float.isNaN(fValue) ? aDefault : Float.valueOf(fValue);
    }

    public static int parseInt(@Nullable Object aObject, int nDefault) {
        return StringParser.parseInt(aObject, 10, nDefault);
    }

    public static int parseInt(@Nullable Object aObject, @Nonnegative int nRadix, int nDefault) {
        if (aObject == null) {
            return nDefault;
        }
        if (aObject instanceof Number) {
            return ((Number)aObject).intValue();
        }
        return StringParser.parseInt(aObject.toString(), nRadix, nDefault);
    }

    public static int parseInt(@Nullable String sStr, int nDefault) {
        return StringParser.parseInt(sStr, 10, nDefault);
    }

    public static int parseInt(@Nullable String sStr, @Nonnegative int nRadix, int nDefault) {
        if (sStr != null && sStr.length() > 0) {
            try {
                return Integer.parseInt(sStr, nRadix);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return nDefault;
    }

    @Nullable
    public static Integer parseIntObj(@Nullable Object aObject) {
        return StringParser.parseIntObj(aObject, 10, null);
    }

    @Nullable
    public static Integer parseIntObj(@Nullable Object aObject, @Nullable Integer aDefault) {
        return StringParser.parseIntObj(aObject, 10, aDefault);
    }

    @Nullable
    public static Integer parseIntObj(@Nullable Object aObject, @Nonnegative int nRadix, @Nullable Integer aDefault) {
        if (aObject == null) {
            return aDefault;
        }
        if (aObject instanceof Number) {
            return ((Number)aObject).intValue();
        }
        return StringParser.parseIntObj(aObject.toString(), nRadix, aDefault);
    }

    @Nullable
    public static Integer parseIntObj(@Nullable String sStr) {
        return StringParser.parseIntObj(sStr, 10, null);
    }

    @Nullable
    public static Integer parseIntObj(@Nullable String sStr, @Nullable Integer aDefault) {
        return StringParser.parseIntObj(sStr, 10, aDefault);
    }

    @Nullable
    public static Integer parseIntObj(@Nullable String sStr, @Nonnegative int nRadix, @Nullable Integer aDefault) {
        if (sStr != null && sStr.length() > 0) {
            try {
                return Integer.valueOf(sStr, nRadix);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return aDefault;
    }

    public static long parseLong(@Nullable Object aObject, long nDefault) {
        return StringParser.parseLong(aObject, 10, nDefault);
    }

    public static long parseLong(@Nullable Object aObject, @Nonnegative int nRadix, long nDefault) {
        if (aObject == null) {
            return nDefault;
        }
        if (aObject instanceof Number) {
            return ((Number)aObject).longValue();
        }
        return StringParser.parseLong(aObject.toString(), nRadix, nDefault);
    }

    public static long parseLong(@Nullable String sStr, long nDefault) {
        return StringParser.parseLong(sStr, 10, nDefault);
    }

    public static long parseLong(@Nullable String sStr, @Nonnegative int nRadix, long nDefault) {
        if (sStr != null && sStr.length() > 0) {
            try {
                return Long.parseLong(sStr, nRadix);
            }
            catch (NumberFormatException ex) {
                // empty catch block
            }
        }
        return nDefault;
    }

    @Nullable
    public static Long parseLongObj(@Nullable Object aObject) {
        return StringParser.parseLongObj(aObject, 10, null);
    }

    @Nullable
    public static Long parseLongObj(@Nullable Object aObject, @Nullable Long aDefault) {
        return StringParser.parseLongObj(aObject, 10, aDefault);
    }

    @Nullable
    public static Long parseLongObj(@Nullable Object aObject, @Nonnegative int nRadix, @Nullable Long aDefault) {
        if (aObject == null) {
            return aDefault;
        }
        if (aObject instanceof Number) {
            return ((Number)aObject).longValue();
        }
        return StringParser.parseLongObj(aObject.toString(), nRadix, aDefault);
    }

    @Nullable
    public static Long parseLongObj(@Nullable String sStr) {
        return StringParser.parseLongObj(sStr, 10, null);
    }

    @Nullable
    public static Long parseLongObj(@Nullable String sStr, @Nullable Long aDefault) {
        return StringParser.parseLongObj(sStr, 10, aDefault);
    }

    @Nullable
    public static Long parseLongObj(@Nullable String sStr, @Nonnegative int nRadix, @Nullable Long aDefault) {
        if (sStr != null && sStr.length() > 0) {
            try {
                return Long.valueOf(sStr, nRadix);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return aDefault;
    }

    public static short parseShort(@Nullable Object aObject, short nDefault) {
        return StringParser.parseShort(aObject, 10, nDefault);
    }

    public static short parseShort(@Nullable Object aObject, @Nonnegative int nRadix, short nDefault) {
        if (aObject == null) {
            return nDefault;
        }
        if (aObject instanceof Number) {
            return ((Number)aObject).shortValue();
        }
        return StringParser.parseShort(aObject.toString(), nRadix, nDefault);
    }

    public static short parseShort(@Nullable String sStr, short nDefault) {
        return StringParser.parseShort(sStr, 10, nDefault);
    }

    public static short parseShort(@Nullable String sStr, @Nonnegative int nRadix, short nDefault) {
        if (sStr != null && sStr.length() > 0) {
            try {
                return Short.parseShort(sStr, nRadix);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return nDefault;
    }

    @Nullable
    public static Short parseShortObj(@Nullable Object aObject) {
        return StringParser.parseShortObj(aObject, 10, null);
    }

    @Nullable
    public static Short parseShortObj(@Nullable Object aObject, @Nullable Short aDefault) {
        return StringParser.parseShortObj(aObject, 10, aDefault);
    }

    @Nullable
    public static Short parseShortObj(@Nullable Object aObject, @Nonnegative int nRadix, @Nullable Short aDefault) {
        if (aObject == null) {
            return aDefault;
        }
        if (aObject instanceof Number) {
            return ((Number)aObject).shortValue();
        }
        return StringParser.parseShortObj(aObject.toString(), nRadix, aDefault);
    }

    @Nullable
    public static Short parseShortObj(@Nullable String sStr) {
        return StringParser.parseShortObj(sStr, 10, null);
    }

    @Nullable
    public static Short parseShortObj(@Nullable String sStr, @Nullable Short aDefault) {
        return StringParser.parseShortObj(sStr, 10, aDefault);
    }

    @Nullable
    public static Short parseShortObj(@Nullable String sStr, @Nonnegative int nRadix, @Nullable Short aDefault) {
        if (sStr != null && sStr.length() > 0) {
            try {
                return Short.valueOf(sStr, nRadix);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return aDefault;
    }

    @Nullable
    public static BigInteger parseBigInteger(@Nullable String sStr) {
        return StringParser.parseBigInteger(sStr, 10, null);
    }

    @Nullable
    public static BigInteger parseBigInteger(@Nullable String sStr, @Nonnegative int nRadix) {
        return StringParser.parseBigInteger(sStr, nRadix, null);
    }

    @Nullable
    public static BigInteger parseBigInteger(@Nullable String sStr, @Nullable BigInteger aDefault) {
        return StringParser.parseBigInteger(sStr, 10, aDefault);
    }

    @Nullable
    public static BigInteger parseBigInteger(@Nullable String sStr, @Nonnegative int nRadix, @Nullable BigInteger aDefault) {
        if (sStr != null && sStr.length() > 0) {
            try {
                return new BigInteger(sStr, nRadix);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return aDefault;
    }

    @Nullable
    public static BigDecimal parseBigDecimal(@Nullable String sStr) {
        return StringParser.parseBigDecimal(sStr, null);
    }

    @Nullable
    public static BigDecimal parseBigDecimal(@Nullable String sStr, @Nullable BigDecimal aDefault) {
        if (sStr != null && sStr.length() > 0) {
            try {
                return new BigDecimal(StringParser._getUnifiedDecimal(sStr));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return aDefault;
    }

    public static boolean isInt(@Nullable String sStr) {
        if (sStr != null) {
            try {
                Integer.parseInt(sStr, 10);
                return true;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return false;
    }

    public static boolean isLong(@Nullable String sStr) {
        if (sStr != null) {
            try {
                Long.parseLong(sStr, 10);
                return true;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return false;
    }

    public static boolean isUnsignedInt(@Nullable String sStr) {
        if (sStr != null) {
            try {
                int ret = Integer.parseInt(sStr, 10);
                return ret >= 0;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return false;
    }

    public static boolean isUnsignedLong(@Nullable String sStr) {
        if (sStr != null) {
            try {
                long ret = Long.parseLong(sStr, 10);
                return ret >= 0L;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return false;
    }

    public static boolean isDouble(@Nullable String sStr) {
        return !Double.isNaN(StringParser.parseDouble(sStr, Double.NaN));
    }

    public static boolean isFloat(@Nullable String sStr) {
        return !Float.isNaN(StringParser.parseFloat(sStr, Float.NaN));
    }
}

