/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.mutable;

import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.mutable.IMutableInteger;
import com.phloc.commons.state.EChange;
import com.phloc.commons.string.ToStringGenerator;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class MutableLong
extends Number
implements IMutableInteger<MutableLong> {
    public static final long DEFAULT_VALUE = 0L;
    private long m_nValue;

    public MutableLong() {
        this(0L);
    }

    public MutableLong(@Nonnull Long aValue) {
        this((long)aValue);
    }

    public MutableLong(long nValue) {
        this.m_nValue = nValue;
    }

    @Override
    public long longValue() {
        return this.m_nValue;
    }

    @Nonnull
    public Long getAsLong() {
        return this.m_nValue;
    }

    @Override
    public float floatValue() {
        return this.m_nValue;
    }

    @Override
    public double doubleValue() {
        return this.m_nValue;
    }

    @Override
    public int intValue() {
        return (int)this.m_nValue;
    }

    public long inc() {
        return this.inc(1L);
    }

    public long inc(long nDelta) {
        this.m_nValue += nDelta;
        return this.m_nValue;
    }

    public long dec() {
        return this.inc(-1L);
    }

    public long dec(long nDelta) {
        return this.inc(-nDelta);
    }

    @Nonnull
    public EChange set(long nValue) {
        if (nValue == this.m_nValue) {
            return EChange.UNCHANGED;
        }
        this.m_nValue = nValue;
        return EChange.CHANGED;
    }

    @Override
    public boolean is0() {
        return this.m_nValue == 0L;
    }

    @Override
    public boolean isNot0() {
        return this.m_nValue != 0L;
    }

    @Override
    public boolean isSmaller0() {
        return this.m_nValue < 0L;
    }

    @Override
    public boolean isSmallerOrEqual0() {
        return this.m_nValue <= 0L;
    }

    @Override
    public boolean isGreater0() {
        return this.m_nValue > 0L;
    }

    @Override
    public boolean isGreaterOrEqual0() {
        return this.m_nValue >= 0L;
    }

    @Override
    public boolean isEven() {
        return this.m_nValue % 2L == 0L;
    }

    @Override
    public boolean isOdd() {
        return this.m_nValue % 2L != 0L;
    }

    @Override
    public int compareTo(MutableLong rhs) {
        return this.m_nValue == rhs.m_nValue ? 0 : (this.m_nValue < rhs.m_nValue ? -1 : 1);
    }

    @Override
    @Nonnull
    public MutableLong getClone() {
        return new MutableLong(this.m_nValue);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MutableLong)) {
            return false;
        }
        MutableLong rhs = (MutableLong)o;
        return this.m_nValue == rhs.m_nValue;
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_nValue).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("value", this.m_nValue).toString();
    }
}

