/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.mock;

import javax.annotation.concurrent.Immutable;

@Immutable
public final class PhlocAssert {
    private static final double DOUBLE_ALLOWED_ROUNDING_DIFFERENCE = 0.001;
    private static final PhlocAssert s_aInstance = new PhlocAssert();

    private PhlocAssert() {
    }

    public static void assertEquals(double x, double y) {
        PhlocAssert.assertEquals(null, x, y);
    }

    public static void assertEquals(double x, Double y) {
        if (y == null) {
            throw new NullPointerException("y");
        }
        PhlocAssert.assertEquals(null, x, y);
    }

    public static void assertEquals(String sUserMsg, double x, double y) {
        if (Double.compare(x, y) != 0 && Math.abs(x - y) > 0.001) {
            throw new IllegalArgumentException("<" + x + "> is not equal to <" + y + ">" + (sUserMsg != null && sUserMsg.length() > 0 ? ": " + sUserMsg : ""));
        }
    }

    public static void assertEquals(float x, float y) {
        PhlocAssert.assertEquals(null, x, y);
    }

    public static void assertEquals(float x, Float y) {
        if (y == null) {
            throw new NullPointerException("y");
        }
        PhlocAssert.assertEquals(null, x, y.floatValue());
    }

    public static void assertEquals(String sUserMsg, float x, float y) {
        if (Float.compare(x, y) != 0 && (double)Math.abs(x - y) > 0.001) {
            throw new IllegalArgumentException("<" + x + "> is not equal to <" + y + ">" + (sUserMsg != null && sUserMsg.length() > 0 ? ": " + sUserMsg : ""));
        }
    }
}

